<?php
declare(strict_types = 1);
namespace app\admin\controller;

use app\common\controller\AdminBase;
use support\Request;
use support\Cache;
class AuthRuleAccess extends AdminBase
{
    protected $MenuPartModel;
    protected $MenuModel;
    protected $AuthRuleModel;
    protected $UserGroupModel;
    protected function initialize()
    {
        parent::initialize();
        $this->CheckAuth(['create','edit','del'],'admin','UserGroup');
        if(!$this->user_auth['index']){
            $this->response('没有此权限','0');
        }
        $this->BaseModel();
        $this->BaseModel('MenuPart','MenuPartModel');
        $this->BaseModel('Menu','MenuModel');
        $this->BaseModel('AuthRule','AuthRuleModel');
        $this->BaseModel('UserGroup','UserGroupModel');
    }
    //  查询用户权限
    protected function IndexCallback($data){
        //  查询用户所属分类
        $group = $this->UserGroupModel->GetOne($this->getdata['fid']);
        //  获取导航
        $menupart = $this->MenuPartModel->GetList(['fid' => $group['fid']],false);
        if(empty($menupart)){
            $this->response('未分配菜单，请先分配菜单','0');
        }
        //  定义当前菜单分类
        $part = empty($this->getdata['mid']) ? $menupart : DelFile($menupart,'id',$this->getdata['mid']);
        $part = $part['0'];
        //  定义保存地址
        $this->list_base['url'] = GetEruUrl('admin/AuthRuleAccess/save',['model' => $part['model'],'fid' => $this->getdata['fid']]);
        //  查询用户组当前菜单
        $listdb = $this->MenuModel->GetList(['fid' => $part['id']],false);
        if(empty($listdb)){
            $this->response('未分配菜单，请先分配菜单','0');
        }
        //  查询已分配菜单
        $_fid = array_unique(array_column($listdb,'aid'));
        $authlist = $this->AuthRuleModel->GetList(['id' => $_fid],false);
        $listdb = $this->model->AuthList($listdb,$authlist,$part['model']);
        //  查询用户组已有权限
        $authlist = $this->model->GetList(['fid' => $this->getdata['fid'],'model' => $part['model']],false);
        //  匹配角色权限
        if(!empty($authlist)){
            foreach ($listdb as &$v){
                $_v = DelFile($authlist,'mid',$v['id']);
                if(empty($_v)){
                    continue;
                }
                $v['default'] = true;
                if(!empty($v['action_part'])){
                    foreach ($v['action_part'] as $k1 => $v1){
                        $_v1 = empty($_v['0']['artion']) ? [] : explode(',',$_v['0']['artion']);
                        if(in_array($k1,$_v1)){
                            $v['action_default'] = empty($v['action_default']) ? [] : $v['action_default'];
                            array_push($v['action_default'],$k1);
                        }
                    }
                }
            }
        }
        foreach ($menupart as &$v){
            $v = [
                'title' => $v['title'],
                'url' => GetEruUrl('admin/AuthRuleAccess/index',['fid' => $this->getdata['fid'],'mid' => $v['id']]),
                'default' => $v['id'] == $part['id'] ? '1' : '0',
            ];
        }
        $this->list_nav = $menupart;
        return $listdb;
    }

    public function save(Request $request)
    {
        $data = $this->SaveCheck();
        $addlist = [];
        if(!empty($data['mid'])){
            foreach ($data['mid'] as $k => $v){
                $_v = [
                    'mid' => $v,
                    'model' => $this->getdata['model'],
                    'fid' => $this->getdata['fid'],
                    'artion' => null,
                ];
                if(!empty($data['action'][$v])){
                    $_v['artion'] = implode(',',$data['action'][$v]);
                }
                array_push($addlist,$_v);
            }
        } else {
            $addlist = ['type' => 'del','model' => $this->getdata['model'],'fid' => $this->getdata['fid']];
        }
        if(!$this->model->SetOne($addlist)){
            $this->response('更改权限失败','0');
        }
        Cache::delete("Auth_{$this->getdata['model']}_{$this->getdata['fid']}");
        $this->response('更改权限成功');
    }
}