<?php
declare(strict_types = 1);
namespace app\common\event;

use app\common\model\{AuthRule,AuthRuleAccess,Menu};
use support\Cache;

class Auth
{
    //  处理权限
    public function Auth($data, $event_name)
    {
        $_fun = explode('.',$event_name);
        $_fun = end($_fun);
        if(!method_exists($this,$_fun)){
            return true;
        }
        return $this->$_fun($data);
    }

    /**
     * @param $data 'fid'=用户组ID,'model'=模块
     * @return array
     */
    protected function UserAuth($data)
    {
        $cacheKey = "Auth_{$data['model']}_{$data['fid']}";
        // 尝试从缓存获取，命中则直接返回
//        if ($res = Cache::get($cacheKey)) {
//            return $res;
//        }

        $_m = new AuthRuleAccess();
        $user_auth = $_m->GetList(['fid' => $data['fid'],'model' => $data['model']],false);
        if (empty($user_auth)) {
            Cache::set($cacheKey, []);
            return [];
        }
        $user_auth = array_column($user_auth, null, 'id');

        $menu = array_unique(array_column($user_auth,'mid'));
        $MenuModel = new Menu();
        $menu = $MenuModel->GetList(['id' => $menu],false);
        //  查询已分配菜单
        $auth = array_unique(array_column($menu,'aid'));
        $AuthModel = new AuthRule();
        $auth = $AuthModel->GetList(['id' => $auth],false);
        $auth = array_column($auth, null, 'id');

        $res = $_m->AuthList($menu,$auth,$data['model']);
        foreach ($res as &$v){
            $_v = DelFile($user_auth,'mid',$v['id']);
            if(empty($_v)){
                continue;
            }
            $v['action'] = empty($_v['0']['artion']) ? '' : $v['action'] . ',' . $_v['0']['artion'];
            if(empty($v['action'])){
                $v['action_part'] = [];
                continue;
            }
            $_v = explode(',',$v['action']);
            $_v = array_unique($_v);
            $action = [];
            foreach ($_v as $v1){
                if(empty($v['action_part'][$v1])){
                    continue;
                }
                $action[$v1] = $v['action_part'][$v1];
            }
            $v['action'] = implode(',',$_v);
            $v['action_part'] = $action;
        }
        unset($v);
        Cache::set($cacheKey,$res);
        return $res;
    }

    /**
     * 验证权限
     * @param $data
     */
    protected function CheckAuth($data){
        $auth = $this->UserAuth(['fid' => $data['fid'],'model' => $data['model']]);
        $_auth = DelFile($auth,'url',request()->path());
        if(!empty($_auth) && $_auth['0']['type'] == '2'){
            $_get = request()->route->getCallback();
            return [$_get['1'] => true];
        }
        $auth = DelFile($auth,'base_part',$data['cname']);
        $targetAuth = [];
        foreach ($auth as $item) {
            if ($item['base_part'] === $data['cname']) {
                $targetAuth = $item;
                break; // 找到即退出
            }
        }
        $res = ['index' => false];
        $actions = [];

        if ($targetAuth) {
            $res['index'] = true;
            $actions = !empty($targetAuth['action']) ? array_flip(explode(',', $targetAuth['action'])) : [];
        }
        foreach ($data['check'] as $checkItem) {
            $res[$checkItem] = isset($actions[$checkItem]);
        }
        return $res;
    }

}