<?php
declare(strict_types = 1);
namespace app\common\model;

class AuthRuleAccess extends R
{
    public function SetOne($data)
    {
        if(!empty($data['type']) && $data['type'] == 'del'){
            if(!$this->whereModel($data['model'])->whereFid($data['fid'])->delete()){
                return false;
            }
            return true;
        }
        $model = array_unique(array_column($data,'model'));
        $fid = array_unique(array_column($data,'fid'));
        $oldlist = $this->GetList(['model' => $model,'fid' => $fid],false);
        if(!empty($oldlist)){
            $del = [];
            foreach ($oldlist as $k => $v){
                $_v = DelFile($data,'mid',$v['mid']);
                if(empty($_v)){
                    array_push($del,$v['id']);
                    unset($oldlist[$k]);
                    continue;
                }
                $_v['0']['id'] = $v['id'];
                $oldlist[$k] = $_v['0'];
                $data = DelFile($data,'mid',$v['mid'],true);
            }
            if(!empty($oldlist)){
                if(!$this->saveAll($oldlist)){
                    return false;
                }
            }
            if(!empty($del)){
                $this->whereIn('id',$del)->delete();
            }
        }
        if(!empty($data)){
            if(!$this->saveAll($data)){
                return false;
            }
        }
        return true;
    }
    /**
     * 获取用户组全部权限
     * @param array $data 要处理的菜单项
     * @param array $auth 要处理的权限组
     * @param string $model 要处理的模块组
     * @return array|object
     */
    public function AuthList($data,$auth,$model){
        $auth = array_column($auth,null,'id');
        foreach ($data as &$v){
            unset($v['addtime'], $v['addip'], $v['sort'], $v['status']);
            switch ($v['type']){
                case '1':
                    if (empty($auth[$v['aid']])) {
                        continue 2; // 跳过无效数据
                    }

                    $v['base_part'] = $auth[$v['aid']]['name'];
                    $v['base_part'] = $auth[$v['aid']]['model'] ? "{$auth[$v['aid']]['model']}.{$v['base_part']}" :  $v['base_part'];
                    $_base_part = $auth[$v['aid']]['model'] ? "{$model}.{$auth[$v['aid']]['name']}" : $auth[$v['aid']]['name'];
                    $_base_part = $auth[$v['aid']]['model'] ? "{$auth[$v['aid']]['model']}/{$_base_part}" : "{$model}/{$_base_part}";

                    $condtion = [];
                    if(!empty($v['condtion'])){
                        foreach (explode(',', $v['condtion']) as $param) {
                            [$key, $value] = explode('=', $param, 2) + [1 => ''];
                            $condtion[$key] = $value;
                        }
                    }
                    $v['url'] = GetEruUrl("{$_base_part}/index",$condtion);
                    if(!empty($v['action'])){
                        foreach (explode(',', $v['action']) as $action) {
                            $v['action_part'][$action] = GetEruUrl("{$_base_part}/{$action}");
                        }
                    }
                    break;
                case '2':
                    if (empty($v['url']) || filter_var($v['url'], FILTER_VALIDATE_URL)) {
                        break;
                    }
                    $_v = explode('?',$v['url']);
                    $arr = [];
                    if(!empty($_v['1'])){
                        foreach (explode('&',$_v['1']) as $v1){
                            [$key, $value] = explode('=', $v1, 2) + [1 => ''];
                            $arr[$key] = $value ?? '';
                        }
                    }
                    $v['url'] = GetEruUrl($_v['0'],$arr);
                    break;
            }
        }
        unset($v);
        return $data;
    }
}