<?php
declare(strict_types = 1);
namespace app\common\model;

class Modular extends R
{
    protected function UntModel($data){
        $_m = new ModularMod();
        foreach ($data as &$v){
            $v['mod_num'] = $_m->CountList(['fid' => $v['id'],'table_type' => 'count']);
        }
        return $data;
    }
    protected function SetOneCallback($data,$Create){
        if(!$Create){
            return $data;
        }
        $webdb = GetWebdb();
        $this->AddDir($data['name'],$webdb);
        $res = $this->AddFile($data['name'],$webdb);
        if(empty($res['code'])){
            $this->whereId($data['id'])->delete();
            return false;
        }
        return $data;
    }
    //  创建项目目录
    public function AddDir($name,$webdb){
        $_homedir = $webdb['web_template'] ?? 'default';
        $_admindir = $webdb['web_template_admin'] ?? 'default';
        $_memberdir = $webdb['web_template_member'] ?? 'default';

        $_dirlist = [
            "app/{$name}/controller/admin",
            "app/{$name}/controller/api",
            "app/{$name}/controller/member",
            "app/{$name}/model",
            "public/home/{$_homedir}/template/{$name}",
            "public/admin/{$_admindir}/template/{$name}",
            "public/member/{$_memberdir}/template/{$name}",
        ];
        foreach ($_dirlist as $v){
            if(!file_exists($v)) {
                @mkdir($v,0755,true);
            }
        }
        return true;
    }
    //  创建默认文件
    public function AddFile($name,$webdb){
        $_homedir = $webdb['web_template'] ?? 'default';
        //  创建前台公用文件
        if(!file_exists("app/{$name}/controller/Base.php")) {
            $res = WriteFile(base_path("app/{$name}/controller/Base.php"), self::_phpBase($name));
            if(empty($res['code'])){
                return $res;
            }
        }
        if(!file_exists("app/{$name}/controller/Index.php")) {
            $res = WriteFile(base_path("app/{$name}/controller/Index.php"), self::_phpDefault($name));
            if(empty($res['code'])){
                return $res;
            }
        }
        //  创建后台公用文件
        if(!file_exists("app/{$name}/controller/admin/Base.php")) {
            $res = WriteFile(base_path("app/{$name}/controller/admin/Base.php"), self::_phpBase($name,'admin'));
            if(empty($res['code'])){
                return $res;
            }
        }
        //  创建API公用文件
        if(!file_exists("app/{$name}/controller/api/Base.php")) {
            $res = WriteFile(base_path("app/{$name}/controller/api/Base.php"), self::_phpBase($name,'api'));
            if(empty($res['code'])){
                return $res;
            }
        }
        //  创建会员中心公用文件
        if(!file_exists("app/{$name}/controller/member/Base.php")) {
            $res = WriteFile(base_path("app/{$name}/controller/member/Base.php"), self::_phpBase($name,'member'));
            if(empty($res['code'])){
                return $res;
            }
        }
        //  创建前台默认文件
        if(!file_exists("public/home/{$_homedir}/template/{$name}/index_index.htm")) {
            $res = WriteFile(public_path("home/{$_homedir}/template/{$name}/index_index.htm"), self::_htmltemp());
            if(empty($res['code'])){
                return $res;
            }
        }
        return ['code' => '1'];
    }
    // 模板文件
    protected static function _htmltemp(){
        $res = <<<HTML
<!doctype html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8" />
    <title>{\$webdb.web_title}</title>
    <meta name="keywords" content="{\$webdb.web_keywords}">
    <meta name="description" content="{\$webdb.web_description}" />
    <meta name="renderer" content="webkit|ie-comp|ie-stand">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="author" content="cxbs.net!ZhaoYan" />
    <link rel="shortcut icon" href="__PUBLIC__/image/favicon.png" type="image/x-icon">
    {load href="__PUBLIC__/css/eru.css"}
</head>
<body class="ery-bg-white-1">
    <div class="layout ery-fex-c ery-fex-itemsc" style="height: 100vh">
        <div class="ery-cont ery-pad-a50 ery-bg-white">
            <h1 class="ery-text-center">模块创建成功</h1>
            <h2 class="ery-text-center ery-mag-t20">{\$webdb.web_title_min}</h2>
        </div>
    </div>
</body>
</html>
HTML;
        return $res;
    }
    // 基础文件
    protected static function _phpBase($dir,$name = ''){
        $_res = "namespace app\\{$dir}\\controller;";
        if(!empty($name)){
            $_res = "namespace app\\{$dir}\\controller\\{$name};";
        }
        $_use = 'HomeBase';
        switch ($name){
            case 'admin':
                $_use = 'AdminBase';
                break;
            case 'api':
                $_use = 'ApiBase';
                break;
            case 'member':
                $_use = 'MemberBase';
                break;
        }
        $res = <<<PHP
<?php
declare(strict_types = 1);
{$_res}

use app\\common\\controller\\{$_use};

class Base extends {$_use}
{
    protected function initialize()
    {
        parent::initialize();
    }
}
PHP;
        return $res;
    }
    protected static function _phpDefault($dir,$name = ''){
        $_res = "namespace app\\{$dir}\\controller;";
        if(!empty($name)){
            $_res = "namespace app\\{$dir}\\controller\\{$name};";
        }
        $res = <<<PHP
<?php
declare(strict_types = 1);
{$_res}

class Index extends Base
{
    protected function initialize()
    {
        parent::initialize();
        
       \$this->list_base['base_part'] = "{$dir}:index";
    }
}
PHP;
        return $res;
    }
}