<?php
declare(strict_types = 1);
namespace app\admin\controller;

use app\common\controller\AdminBase;
use app\common\model\{LogUser,Modular,ModularMod,User};
use support\Cache;
use support\Request;
use Webman\Event\Event;

class Index extends AdminBase
{
    protected function initialize()
    {
        parent::initialize();
        switch ($this->request->action) {
            case 'index':
                $this->list_base['template'] = $this->request->action;
                break;
        }
    }
    public function map(Request $request){
        return $this->ResAdminRead();
    }
    public function menu(){
        $res = Event::dispatch('auth.UserAuth',['fid' => $this->ImUser['u_groupid'],'model' => $this->space_name]);
        $res = DelFile($res['0'],'mapsee','0');
        return $this->ResAdminList($res);
    }
    //  查询用户数据
    public function user(){
        //  查询用户总数量
        $_m = new User();
        $res['user_num'] = $_m->CountList(['table_type' => 'count']);
        $res['user_m_num'] = $_m->CountList(['table_type' => 'count','GetTimes' => 'addtime','addtime_m' => 'm']);
        $res['user_d_num'] = $_m->CountList(['table_type' => 'count','GetTimes' => 'addtime','addtime_d' => 'd']);
        //  查询今日登录用户
        $_m = new LogUser();
        $res['log_d_num'] = $_m->CountList(['table_type' => 'count','count' => 'uid','table_distinct' => 'uid,id','GetTimes' => 'addtime','addtime_d' => 'd']);
        return $this->ResAdminRead($res);
    }
    public function delcache(){
        DelDir(runtime_path('sessions'));
        DelDir(runtime_path('views'));
        DelDir(runtime_path('cache'));
        Cache::clear();
        ResJson('删除缓存成功');
    }
    //  查询模型数据统计
    public function mod(){
        //  查询网站模块
        $_m = new Modular();
        $read = $_m->GetList(['GetFile' => 'title,id,name','order' => 'id asc'],false);
        //  查询模型
        $_m = new ModularMod();
        $fid = array_column($read,'id');
        $fid = $_m->GetList(['fid' => $fid,'map_see' => '1','GetFile' => 'id,fid,title,name,name_key','order' => 'id asc'],false);
        $res = [];
        //  查询模型数据
        foreach ($read as $k => $v){
            $_v = DelFile($fid,'fid',$v['id']);
            if(empty($_v)){
                unset($read[$k]);
                continue;
            }
            foreach ($_v as &$v1){
                $_mod = "\\app\\{$v['name']}\\model\\{$v1['name_key']}";
                $_mod = new $_mod;
                $v1['cont_num'] = $_mod->CountList(['table_type' => 'count']);
                $v1['fid_title'] = $v['title'];
                $v1['fid_name'] = $v['name'];
                $res[] = $v1;
            }
        }
        return $this->ResAdminRead($res);
    }
    //  重启服务，刷新配置
    public function restart(){
        $reload = base_path('start.php');
        $pip = [['pipe', 'r'], ['pipe', 'w'], ['pipe', 'w']];
        $execute = [
            'reload' => [
                'proc' => 'reload',
                'title' => '重启服务',
            ],
            'stop' => [
                'proc' => 'stop',
                'title' => '停止服务',
            ],
        ];
        $res = proc_open("php {$reload} {$execute[$this->getdata['proc']]['proc']}", $pip, $pipes);
        fclose($pipes[0]);
        $out = stream_get_contents($pipes[1]);
        fclose($pipes[1]);
        $err = stream_get_contents($pipes[2]);
        fclose($pipes[2]);
        $res = proc_close($res);
        if($res != 0){
            ResJson("{$execute[$this->getdata['proc']]['title']}失败：" . $err,'0');
        }
        ResJson("{$execute[$this->getdata['proc']]['title']}成功");
    }
}