<?php
declare(strict_types = 1);
namespace app\admin\controller;

use app\common\controller\AdminBase;

class Menu extends AdminBase
{
    protected $PartModel;
    protected $PartList;
    protected $AuthModel;
    protected function initialize()
    {
        parent::initialize();
        if(!$this->user_auth['index']){
            $this->response('没有此权限','0');
        }
        $this->BaseModel();
        $this->BaseModel('MenuPart','PartModel');
        $this->BaseModel('AuthRule','AuthModel');
        $this->list_base['page'] = false;
        $this->list_base['fold'] = true;
        $this->PartList = $this->PartModel->GetList([],false);
        $this->getdata['fid'] = $this->getdata['fid'] ?? $this->PartList['0']['id'];
        switch ($this->request->action){
            case 'index':
                $this->list_base['url'] = GetEruUrl('admin/Menu/getlist',$this->getdata);
                $this->list_base['fast_url'] = GetEruUrl('admin/Menu/fastedit');
                $this->ListTable();
                break;
            case 'create':
            case 'edit':
            case 'save':
                $this->list_base['url'] = GetEruUrl('admin/Menu/save',$this->getdata);
                $this->list_base['title'] = $this->request->action == 'create' ? '添加菜单' : '编辑菜单';
                $this->FormFile();
                break;
        }
    }
    protected function ListTable(){
        $this->list_file = [
            ['field' => 'id','title' => 'ID','width' => '80','textalign' => 'center'],
            ['field' => 'title','title' => '菜单名称'],
            ['field' => 'sort','title' => '排序值','width' => '80','type' => $this->user_auth['edit'] ? 'edit' : 'text','textalign' => 'center'],
            ['field' => 'status','title' => '状态','type' => 'radio','list' => ['禁用','启用'],'textalign' => 'center','width' => '100'],
        ];
        if($this->user_auth['edit']) {
            //  这里要做判断
            array_push($this->list_file, [
                'field' => 'type', 'title' => '子菜单', 'width' => '80', 'type' => 'btn', 'list' => ['0'], 'textalign' => 'center','open' => 'true', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-add', 'url' => GetEruUrl('admin/Menu/create', ['pid' => '__id__','fid' => '__fid__'])
            ], [
                'field' => 'edit', 'title' => '编辑', 'width' => '80', 'type' => 'btn', 'textalign' => 'center','open' => 'true', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-edit', 'url' => GetEruUrl('admin/Menu/edit',['id' => '__id__']), 'fixed' => 'right'
            ]);
        }
        if($this->user_auth['del']) {
            $this->list_file[] = [
                'field' => 'del', 'title' => '删除', 'width' => '80', 'type' => 'btn', 'event' => 'del', 'textalign' => 'center', 'class' => 'ery-text-red ery-text-f16', 'icon' => 'im-icon im-delete', 'url' => GetEruUrl('admin/Menu/del', ['id' => '__id__']), 'fixed' => 'right'
            ];
        }
        if($this->user_auth['create']) {
            $this->list_base['button'] = [
                ['title' => '添加菜单', 'open' => true, 'url' => GetEruUrl('admin/Menu/create',['fid' => $this->getdata['fid']])]
            ];
        }
        foreach ($this->PartList as &$v){
            $v = [
                'title' => $v['title'],
                'url' => GetEruUrl('admin/Menu/index',['fid' => $v['id']]),
                'default' => $this->getdata['fid'] == $v['id'] ? '1' : '0',
            ];
        }
        $this->list_nav = $this->PartList;
    }
    protected function FormFile(){
        //  查询权限列表
        $_authlist = $this->AuthModel->GetList([],false);
        $_authlist = $this->AuthModel->UntList($_authlist);
        foreach ($_authlist as &$v){
            $v['title'] = empty($v['model']) ? $v['title'] : $v['model_name'] . ' - ' . $v['title'];
        }
        $_authlist = SelectEdit($_authlist,['title' => 'title','value' => 'id']);
        if(!empty($this->request->route->param('id'))){
            $_fid = $this->model->GetOne($this->request->route->param('id'),false);
            $this->getdata['fid'] = $_fid['fid'] ?? $this->PartList['0']['id'];
        }
        //  查询现有菜单
        $_partlist = $this->model->GetList(['fid' => $this->getdata['fid'] ?? $this->PartList['0']['id']],false);
        $_pid = [
            'id' => $this->request->route->param('id') ?? '0',
            'on' => !empty($this->request->route->param('id')),
        ];
        $_partlist = FormatPart($_partlist,$_pid,['title' => 'title_display']);
        $_partlist = array_merge([['title' => '顶级菜单','value' => '0']],$_partlist);
        //  打包菜单数据
        $this->list_file = [
            ['field' => 'pid','title' => '上级菜单','type' => 'select','list' => $_partlist,'default' => $this->getdata['pid'] ?? '','tip' => '不选则为顶级菜单'],
            ['field' => 'title','title' => '菜单名称','type' => 'text','required' => true],
            ['field' => 'type','title' => '类型','type' => 'radio','list' => [['title' => '分组','value' => '0'],['title' => '菜单','value' => '1'],['title' => '自订义链接','value' => '2']],'default' => '0','required' => true,'file_link' => ['1'=> ['aid','condtion','action'],'2'=> ['url']]],
            ['field' => 'aid','title' => '跳转地址','text' => true,'type' => 'select','list' => $_authlist],
            ['field' => 'action','title' => '编辑权限', 'type' => 'checkbox','list' => [
                ['title' => '查看数据','value' => 'read'],
                ['title' => '新增数据','value' => 'create'],
                ['title' => '修改数据','value' => 'edit'],
                ['title' => '删除数据','value' => 'del'],
            ]],
            ['field' => 'url','title' => '跳转地址','type' => 'text'],
            ['field' => 'condtion','title' => '附加规则','type' => 'text','tip' => '一般为空，如不懂程序，请勿添加'],
            ['field' => 'icon_type','title' => '图标类型','type' => 'radio','list' => [['title' => 'ICON','value' => '0'],['title' => '图片','value' => '1']],'default' => '0','file_link' => [['icon'],['icon_img']],],
            ['field' => 'icon','title' => '菜单图标','type' => 'icon'],
            ['field' => 'icon_img','title' => '菜单图标','type' => 'image'],
            ['field' => 'sort','title' => '排序值','type' => 'text','type_edit' => 'number','default' => '0'],
            ['field' => 'mapsee','title' => '列表显示','type' => 'radio','list' => [['title' => '显示','value' => '0'],['title' => '隐藏','value' => '1']],'default' => '0','required' => true],
            ['field' => 'status','title' => '是否启用','type' => 'radio','list' => [['title' => '启用','value' => '1'],['title' => '禁用','value' => '0']],'default' => '1','required' => true],
            ['field' => 'fid','title' => 'FID','required' => true,'type' => 'hidden','default' => $this->getdata['fid'] ?? $this->PartList['0']['id']]
        ];
        if($this->request->action == 'edit' || !empty($this->getdata['id'])){
            $this->list_file[] = ['field' => 'id', 'title' => 'ID', 'required' => true, 'type' => 'hidden'];
        }
    }
}