<?php
declare(strict_types = 1);
namespace app\admin\controller;

use app\common\controller\AdminBase;
use support\Cache;

class Modular extends AdminBase
{
    protected $ModModel;
    protected function initialize()
    {
        parent::initialize();
        if(!$this->user_auth['index']){
            $this->response('没有此权限','0');
        }
        $this->BaseModel();
        $this->BaseModel('ModularMod','ModModel');
        $this->BaseValidate();
        switch ($this->request->action){
            case 'index':
                $this->list_base['fast_url'] = GetEruUrl('admin/Modular/fastedit',$this->getdata);
                $this->list_base['url'] = GetEruUrl('admin/Modular/getlist',$this->getdata);
                $this->ListTable();
                break;
            case 'create':
            case 'edit':
            case 'save':
                $this->list_base['url'] = GetEruUrl('admin/Modular/save',$this->getdata);
                $this->list_base['title'] = $this->request->action == 'create' ? '添加模块' : '编辑模块';
                $this->FormFile();
                break;
            case 'donw':
                $this->list_base['url'] = route('admin.Modular.export',$this->getdata);
                $this->list_base['title'] = '导出模块';
                $this->FormFile();
                break;
            case 'add':
                $this->list_base['url'] = route('admin.Modular.import',$this->getdata);
                $this->list_base['title'] = '安装模块';
                break;
        }
    }
    protected function ListTable(){
        if($this->user_auth['create']) {
            $this->list_base['button'] = [
                ['title' => '添加模块', 'url' => GetEruUrl('admin/Modular/create'),'open' => true],
                ['title' => '安装模块', 'url' => route('admin.Modular.add'),'class' => 'ery-button ery-bg-green ery-mag-l10','open' => true],
            ];
        }
        $this->list_file = [
            ['field' => 'id','title' => 'ID','width' => '80','textalign' => 'center','fixed' => 'left'],
            ['field' => 'title','title' => '模块名称',],
            ['field' => 'name','title' => '模块地址',],
            ['field' => 'mod_num','title' => '模型数量','width' => '150','textalign' => 'center'],
            ['field' => 'sort','title' => '排序值','width' => '80','type' => $this->user_auth['edit'] ? 'edit' : 'text','textalign' => 'center'],
            ['field' => 'status','title' => '状态','type' => 'radio','list' =>['禁用','启用'],'textalign' => 'center','width' => '100'],
        ];
        if($this->user_auth['edit']) {
            array_push($this->list_file,
                ['field' => 'edit_cont', 'title' => '模型', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-caozuoxitong', 'url' => GetEruUrl('admin/ModularMod/index', ['fid' => '__id__']),'fixed' => 'right'],
                ['field' => 'read', 'title' => '导出', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-caozuoxitong', 'url' => route('admin.Modular.donw', ['id' => '__id__']),'fixed' => 'right'],
                ['field' => 'edit', 'title' => '编辑', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-edit', 'url' => GetEruUrl('admin/Modular/edit', ['id' => '__id__']),'open' => true,'fixed' => 'right']
            );
        }
        if($this->user_auth['del']) {
            $this->list_file[] = [
                'field' => 'del', 'title' => '卸载', 'width' => '80', 'type' => 'btn', 'event' => 'del', 'textalign' => 'center', 'class' => 'ery-text-red ery-text-f16', 'icon' => 'im-icon im-tuichu', 'url' => GetEruUrl('admin/Modular/del', ['id' => '__id__']), 'tip' => '卸载后不可恢复，是否确认卸载？', 'fixed' => 'right'];
        }
    }
    protected function FormFile(){
        $this->list_file = [
            ['field' => 'title','title' => '模块名称','type' => 'text','required' => true],
            ['field' => 'name','title' => '模块URL','type' => 'text','tip' => '只能为小写字母，如: cms','required' => $this->request->action != 'edit','disabled' => $this->request->action == 'edit'],
            ['field' => 'sort','title' => '排序值','type' => 'text','type_edit' => 'number','default' => '0'],
            ['field' => 'status','title' => '是否启用','type' => 'radio','list' => [['title' => '启用','value' => '1'],['title' => '禁用','value' => '0']],'default' => '1','required' => true]
        ];
        if($this->request->action == 'edit' || !empty($this->getdata['id'])){
            $this->list_file[] = ['field' => 'id', 'title' => 'ID', 'required' => true, 'type' => 'hidden'];
        }
    }

    public function donw(){
        $this->list_base['template'] = 'public:add_excel';
        $modlist = $this->ModModel->GetList(['fid' => $this->getdata['id'],'status' => '1'],false);
        $this->list_file = [
            ['field' => 'modlist','title' => '请选择模型','type' => 'checkbox','list' => SelectEdit($modlist,['value' => 'id']),'required' => true],
            ['field' => 'id','title' => 'ID','type' => 'hidden','default' => $this->getdata['id'],'required' => true],
        ];
        return $this->ResAdminForm();
    }
    //  导出模块
    public function export(){
        if(empty($this->getdata['modlist'])){
            $this->response('请选择要导出的模型','0');
        }
        $mod = $this->model->GetOne($this->getdata['id'],false);
        // 读取模型信息
        $modlist = $this->ModModel->GetList(['id' => $this->getdata['modlist']],false);

        $_v = "app/{$mod['name']}/controller/admin/Base.php";
        if(is_file(base_path($_v))){
            CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
        }
        $_v = "app/{$mod['name']}/controller/member/Base.php";
        if(is_file(base_path($_v))){
            CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
        }
        $_v = "app/{$mod['name']}/controller/home/Base.php";
        if(is_file(base_path($_v))){
            CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
        }
        $_v = "app/{$mod['name']}/controller/api/Base.php";
        if(is_file(base_path($_v))){
            CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
        }
        // 复制模型文件
        foreach ($modlist as $v){
            $v['open'] = explode(',',$v['open']);
            // 复制后台文件
            if(in_array('admin', $v['open'])){
                $_v = "app/{$mod['name']}/controller/admin/{$v['name_key']}.php";
                if(is_file(base_path($_v))){
                    CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
                }
                // 读取文件夹
                $_dir = "admin/{$this->webdb['web_template_admin']}/template/{$mod['name']}";
                if(is_dir(public_path($_dir))){
                    $_v = $this->GetFileList($_dir,$v['name']);
                    if(!empty($_v)){
                        foreach ($_v as $vv) {
                            CopyFiles(public_path("{$_dir}/{$vv}"), public_path("upload_file/export/{$mod['name']}/public/{$_dir}/{$vv}"));
                        }
                    }
                }
            }
            // 复制前台文件
            if(in_array('home', $v['open'])){
                $_v = "app/{$mod['name']}/controller/home/{$v['name_key']}.php";
                if(is_file(base_path($_v))){
                    CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
                }
                // 读取文件夹
                $_dir = "home/{$this->webdb['web_template']}/template/{$mod['name']}";
                if(is_dir(public_path($_dir))){
                    $_v = $this->GetFileList($_dir,$v['name']);
                    if(!empty($_v)){
                        foreach ($_v as $vv) {
                            CopyFiles(public_path("{$_dir}/{$vv}"), public_path("upload_file/export/{$mod['name']}/public/{$_dir}/{$vv}"));
                        }
                    }
                }
            }
            // 复制会员中心文件
            if(in_array('member', $v['open'])){
                $_v = "app/{$mod['name']}/controller/member/{$v['name_key']}.php";
                if(is_file(base_path($_v))){
                    CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
                }
                // 读取文件夹
                $_dir = "member/{$this->webdb['web_template_member']}/template/{$mod['name']}";
                if(is_dir(public_path($_dir))){
                    $_v = $this->GetFileList($_dir,$v['name']);
                    if(!empty($_v)){
                        foreach ($_v as $vv) {
                            CopyFiles(public_path("{$_dir}/{$vv}"), public_path("upload_file/export/{$mod['name']}/public/{$_dir}/{$vv}"));
                        }
                    }
                }
            }
            // 复制api文件
            if(in_array('api', $v['open'])){
                $_v = "app/{$mod['name']}/controller/api/{$v['name_key']}.php";
                if(is_file(base_path($_v))){
                    CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
                }
            }
            // 复制模型文件
            $_v = "app/{$mod['name']}/model/{$v['name_key']}.php";
            if(is_file(base_path($_v))){
                CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
            }
            // 复制验证器文件
            $_v = "app/{$mod['name']}/validate/{$v['name_key']}.php";
            if(is_file(base_path($_v))){
                CopyFiles(base_path($_v),public_path("upload_file/export/{$mod['name']}/{$_v}"));
            }
        }
        Cache::set("export_mod_{$this->getdata['id']}",$this->getdata['modlist'],300);
        $this->response('文件导出成功,开始备份数据文件......','2',['url' => GetEruUrl('admin.Modular.exportsql',['id' => $this->getdata['id']])]);
    }
    // 导出数据库文件
    public function exportsql(){
        $modlist = Cache::get("export_mod_{$this->getdata['id']}",[]);
        if(empty($modlist)){
            $this->response('导出失败，请重新导出','0');
        }
        $mod = $this->model->GetOne($this->getdata['id'],false);
        // 读取模型信息
        $modlist = $this->ModModel->GetList(['id' => $modlist],false);
        // 写入Sql文件
        $add_value = [
            ['table_name' => 'modular','data' => ['id' => $mod['id'],'title' => $mod['title'],'name' => $mod['name'],'sort' => $mod['sort'],'status' => $mod['status']]]
        ];
        foreach ($modlist as $v){
            unset($v['addtime'],$v['edittime'],$v['del_time']);
            array_push($add_value,[
                'table_name' => 'modular_mod',
                'data' => $v
            ]);
        }
        // 获取字段信息
        $_m = new \app\common\model\ModularField();
        $fid = array_column($modlist, 'id');
        $fieldlist = $_m->GetList(['fid' => $fid,'status' => '1'],false);
        foreach ($fieldlist as $v){
            unset($v['addtime'],$v['edittime'],$v['del_time']);
            $add_value[] = [
                'table_name' => 'modular_field',
                'data' => $v
            ];
        }
        // 写入数据库文件
        $sql_file = "upload_file/export/{$mod['name']}/updatesql.php";
        WriteFile(public_path($sql_file), json_encode($add_value,JSON_UNESCAPED_UNICODE));
        Cache::delete("export_mod_{$this->getdata['id']}");
        $this->response('备份数据文件完成，开始打包压缩文件......','2',['url' => GetEruUrl('admin.Modular.exportzip',['id' => $this->getdata['id']])]);
    }
    // 打包压缩文件
    public function exportzip(){
        $mod = $this->model->GetOne($this->getdata['id'],false);
        $dir = public_path("upload_file/export/{$mod['name']}");
        if (!extension_loaded('zip') || !file_exists($dir)) {
            $this->response('请安装zip扩展或文件不存在','0');
        }

        $zip_file = "upload_file/export/{$mod['name']}.zip";
        $zip = new \ZipArchive();
        if (!$zip->open(public_path($zip_file), \ZipArchive::CREATE)) {
            $this->response('创建压缩文件失败','0');
        }

        if (is_dir($dir)) {
            $dir_iterator = new \RecursiveDirectoryIterator($dir);
            $iterator = new \RecursiveIteratorIterator($dir_iterator,\RecursiveIteratorIterator::SELF_FIRST);
            foreach ($iterator as $file) {
                $file = str_replace('\\', '/', $file->getPathname());
                if (in_array(substr($file, strrpos($file, '/')+1), array('.', '..'))){
                    continue;
                }
                $file = realpath($file);
                if (is_dir($file) === true) {
                    $zip->addEmptyDir(str_replace($dir . '/', '', $file . '/'));
                } else if (is_file($file) === true) {
                    $zip->addFromString(str_replace($dir . '/', '', $file), file_get_contents($file));
                }
            }
        } else if (is_file($dir)) {
            $zip->addFromString(basename($dir), file_get_contents($dir));
        }
        $zip->close();
        DelDir(public_path("upload_file/export/{$mod['name']}"));
        $this->response('文件打包成功,请下载文件','1',['url' => "/{$zip_file}"]);
    }
    // 查询模板文件
    protected function GetFileList($dir,$name){
        $filelist = GetDirlist(public_path($dir));
        $res = [];
        foreach ($filelist as $k => $v){
            // 文件名不是name开头
            if(strpos($v,$name) !== 0){
                continue;
            }
            array_push($res,$v);
        }
        return $res;
    }
    //  将图片压入zip
    protected function newsetzip($filename,$setdir,\ZipArchive $zip){
        if(is_dir($filename)){
            $filelist = GetDirlist($filename);
            foreach ($filelist as $k => $v){
                $this->newsetzip($v,$setdir.$filename.'/',$zip);
            }
        }else{
            $zip->addFile($filename, "{$setdir}.txt");
        }
        $zip->addFile($filename, "{$setdir}.txt");
        return true;
    }

    // 安装模块
    public function add(){
        $this->list_base['template'] = 'public:add_excel';
        $this->list_file = [
            ['field' => 'mod','title' => '选择文件','type' => 'zip','required' => true],
        ];
        return $this->ResAdminForm();
    }
    public function import(){
        $this->validate = false;
        $data = $this->SaveCheck();
        if(empty($data['mod'])){
            $this->response('请选择要导入的模块','0');
        }
        Cache::set('mod_import_data',$data['mod']);
        $this->response('上传成功，开始解压模块......','2',['url' => GetEruUrl('admin.Modular.importzip')]);
    }
    public function importzip(){
        $zip_file = Cache::get('mod_import_data');
        // 解压模块
        $zip = new \ZipArchive();
        if (!$zip->open(public_path($zip_file), \ZipArchive::CREATE)) {
            $this->response('解缩文件失败','0');
        }
        $zip->extractTo(public_path("upload_file/import"));
        $zip->close();
        $this->response('解压成功，开始导入模块......','2',['url' => GetEruUrl('admin.Modular.importfile')]);
    }
    public function importfile(){
        $dir = public_path("upload_file/import");
        $dir_iterator = new \RecursiveDirectoryIterator($dir);
        $iterator = new \RecursiveIteratorIterator($dir_iterator,\RecursiveIteratorIterator::SELF_FIRST);
        foreach ($iterator as $file) {
            if($file->isDir() || basename($file->getFilename()) == 'updatesql.php'){
                continue;
            }
            $file = str_replace('\\', '/', $file->getPathname());
            if (in_array(substr($file, strrpos($file, '/')+1), array('.', '..'))){
                continue;
            }
            $file = realpath($file);
            // 移动文件到对应目录
            $_file = str_replace($dir . '/', '', $file);
            CopyFiles($file,$_file);
        }
        $this->response('导入成功，开始导入数据文件......','2',['url' => GetEruUrl('admin.Modular.importsql')]);
    }
    public function importsql(){
        $dir = public_path("upload_file/import/updatesql.php");
        if(!is_file($dir)){
            $this->response('模块安装完成');
        }
        $data = json_decode(file_get_contents($dir),true);
        $mod = DelFile($data,'table_name','modular');
        $modlist = DelFile($data,'table_name','modular_mod');
        $fieldlist = DelFile($data,'table_name','modular_field');

        // 导入模块信息
        foreach ($mod as &$v){
            $_v = $v['data'];
            unset($_v['id']);
            $old = $this->model->GetList(['name' => $_v['name']],false);
            if(!empty($old)) {
                $_v = $old['0'];
            } else {
                $_v = $this->model->EditAdd($_v);
                $_v = $this->model->SetOne($_v);
            }
            $v['data']['new_id'] = $_v['id'];
        }
        // 导入模型信息
        $_modlist = [];
        foreach ($modlist as &$v){
            $_v = $v['data'];
            unset($_v['id']);
            $old = $this->ModModel->GetList(['name' => $_v['name'],'fid' => $mod['0']['data']['new_id']],false);
            if(!empty($old)) {
                $_v = $old['0'];
            } else {
                $_v['fid'] = $mod['0']['data']['new_id'];
                $_v = $this->ModModel->EditAdd($_v);
                $_v = $this->ModModel->SetOne($_v);
                $this->ModModel->NewSetSql($mod['0']['data']['name'],$_v['name'],$_v['title']);
                $this->ModModel->NewSetAuth($mod['0']['data']['name'],$_v['name_key'],$_v['title']);
            }
            $v['data']['new_id'] = $_v['id'];
            array_push($_modlist,$v['data']);
        }
        // 导入字段信息
        $_m = new \app\common\model\ModularField();
        foreach ($fieldlist as &$v){
            $_up = DelFile($_modlist,'id',$v['data']['fid']);
            $_v = $v['data'];
            unset($_v['id']);
            $old = $_m->GetList(['field' => $_v['field'],'fid' => $_up['0']['new_id']],false);
            if(empty($old)) {
                $_v['fid'] = $_up['0']['new_id'];
                $_v = $_m->EditAdd($_v);
                $_v = $_m->SetOne($_v);
            }
        }
        $file = Cache::get('mod_import_data');
        DelWebFile($file);
        DelDir(public_path("upload_file/import"));
        Cache::delete('mod_import_data');
        $this->response('数据导入成功，模块安装完成','1',$data);
    }
}