<?php
declare(strict_types = 1);
namespace app\admin\controller;

use app\common\controller\AdminBase;

class ModularMod extends AdminBase
{
    protected function initialize()
    {
        parent::initialize();
        $this->CheckAuth(['read','create','edit','del'],'admin','Modular');
        if(!$this->user_auth['index']){
            $this->response('没有此权限','0');
        }
        $this->BaseModel();
        switch ($this->request->action){
            case 'index':
                $this->list_base['fast_url'] = GetEruUrl('admin/ModularMod/fastedit',$this->getdata);
                $this->list_base['url'] = GetEruUrl('admin/ModularMod/getlist',$this->getdata);
                $this->ListTable();
                break;
            case 'create':
            case 'edit':
            case 'save':
                $this->list_base['url'] = GetEruUrl('admin/ModularMod/save',$this->getdata);
                $this->list_base['title'] = $this->request->action == 'create' ? '添加模型' : '编辑模型';
                $this->FormFile();
                break;
        }
    }
    protected function ListTable(){
        if($this->user_auth['create']) {
            $this->list_base['button'] = [
                ['title' => '返回模块', 'url' => GetEruUrl('admin/Modular/index'),'class' => 'ery-button'],
                ['title' => '添加模型', 'url' => GetEruUrl('admin/ModularMod/create',$this->getdata),'open' => true],
            ];
        }
        $this->list_file = [
            ['field' => 'id','title' => 'ID','width' => '80','textalign' => 'center'],
            ['field' => 'title','title' => '模型名称'],
            ['field' => 'name','title' => '模型地址','width' => '150'],
            ['field' => 'fid_title','title' => '所属模块','width' => '200','textalign' => 'center'],
            ['field' => 'field_num','title' => '字段数量','width' => '100','textalign' => 'center'],
            ['field' => 'cont_num','title' => '内容数量','width' => '100','textalign' => 'center'],
            ['field' => 'sort','title' => '排序值','width' => '80','type' => $this->user_auth['edit'] ? 'edit' : 'text','textalign' => 'center'],
            ['field' => 'status','title' => '状态','type' => 'radio','list' =>['禁用','启用'],'textalign' => 'center','width' => '100'],
            ['field' => 'addtime','title' => '添加时间','width' => '180','textalign' => 'center'],
        ];
        if($this->user_auth['edit']) {
            array_push($this->list_file,
                ['field' => 'edit_cont', 'title' => '字段', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-caozuo', 'url' => GetEruUrl('admin/ModularField/index', ['fid' => '__id__','mid' => '__fid__']),'fixed' => 'right'],
                ['field' => 'edit_file', 'title' => '生成', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-caozuoxitong ery-text-yellow', 'url' => GetEruUrl('admin/ModularMod/addfile', ['id' => '__id__']),'tip' => '生成文件会清除原有文件，请问是否生成','event' => 'edit_file','fixed' => 'right'],
                ['field' => 'edit', 'title' => '编辑', 'width' => '80', 'type' => 'btn', 'textalign' => 'center', 'class' => 'ery-text-green ery-text-f16', 'icon' => 'im-icon im-edit', 'url' => GetEruUrl('admin/ModularMod/edit', ['id' => '__id__','fid' => '__fid__']),'fixed' => 'right','open' => true]
            );
        }
        if($this->user_auth['del']) {
            $this->list_file[] = [
                'field' => 'del', 'title' => '删除', 'width' => '80', 'type' => 'btn', 'event' => 'del', 'textalign' => 'center', 'class' => 'ery-text-red ery-text-f16', 'icon' => 'im-icon im-delete', 'url' => GetEruUrl('admin/ModularMod/del', ['id' => '__id__']), 'fixed' => 'right'];
        }
    }
    protected function FormFile(){
        $this->list_file = [
            ['field' => 'title','title' => '模型名称','type' => 'text','required' => true],
            ['field' => 'name','title' => '模型URL','type' => 'text','tip' => '只能为英文字母，创建后禁止修改。','required' => $this->request->action != 'edit','disabled' => $this->request->action == 'edit'],
            ['field' => 'open','title' => '开放接口','type' => 'checkbox','list' => [
                ['title' => '后台模块','value' => 'admin'],
                ['title' => '前台模块','value' => 'home'],
                ['title' => 'API模块','value' => 'api'],
                ['title' => '会员中心模块','value' => 'member']
            ],'required' => true,'tip' => '一般情况下，后台模块为必选'],
            ['field' => 'sort','title' => '排序值','type' => 'text','type_edit' => 'number','default' => '0'],
            ['field' => 'pages','title' => '分页','type' => 'radio','list' => [['title' => '分页','value' => '0'],['title' => '不分页','value' => '1'],['title' => '层级显示','value' => '2']],'default' => '0','required' => true],
            ['field' => 'list_order','title' => '排序方式','type' => 'select','list' => [['title' => '默认排序','value' => '0'],['title' => '按添加倒序','value' => 'id desc'],['title' => '按添加正序','value' => 'id asc']],'default' => '0','required' => true],
            ['field' => 'map_see','title' => '后台首页显示','type' => 'radio','list' => [['title' => '显示','value' => '1'],['title' => '不显示','value' => '0']],'default' => '1','required' => true],
            ['field' => 'see_sort','title' => '列表排序','type' => 'radio','list' => [['title' => '列表显示','value' => '1'],['title' => '不显示','value' => '0']],'default' => '1','required' => true],
            ['field' => 'see_addtime','title' => '添加时间','type' => 'radio','list' => [['title' => '列表显示','value' => '1'],['title' => '不显示','value' => '0']],'default' => '1','required' => true],
            ['field' => 'see_addip','title' => '添加IP','type' => 'radio','list' => [['title' => '列表显示','value' => '1'],['title' => '不显示','value' => '0']],'default' => '1','required' => true],
            ['field' => 'status','title' => '是否启用','type' => 'radio','list' => [['title' => '启用','value' => '1'],['title' => '禁用','value' => '0']],'default' => '1','required' => true],
            ['field' => 'fid','title' => 'FID','required' => true,'type' => 'hidden','default' => $this->getdata['fid']]
        ];
        if($this->request->action == 'edit' || !empty($this->getdata['id'])){
            $this->list_file[] = ['field' => 'id', 'title' => 'ID', 'required' => true, 'type' => 'hidden'];
        }
    }
    //  验证
    protected function SaveSelf($data,$old = []){
        if(empty($data['id'])){
            $old = $this->model->GetList(['fid' => $data['fid'],'name' => $data['name']]);
            if($old['total'] > '0'){
                $this->response('模型URL已存在','0');
            }
        }
        return $data;
    }
    //  生成文件
    public function addfile(){
        $files = $this->model->GetOne($this->getdata['id']);
        $res = $this->model->NewSetSql($files['fid_name'],$files['name'],$files['title']);
        if(!$res){
            $this->response('数据库生成失败，请检查','0');
        }
        $res = $this->model->NewSetAuth($files['fid_name'],$files['name_key'],$files['title']);
        if(!$res){
            $this->response('权限写入失败，请检查','0');
        }
        // 生成配置文件
        $_m = new \app\common\model\Modular();
        $_m->AddDir($files['fid_name'],$this->webdb);
        $_m->AddFile($files['fid_name'],$this->webdb);

        $res = $this->model->NewSetFile($files);
        if(!$res){
            $this->response('文件生成失败，请检查','0');
        }
        $this->response('文件生成成功');
    }
}