<?php
declare(strict_types = 1);
namespace app\common\controller;

use support\Cache;
use support\View;
use Webman\Event\Event;

abstract class Base
{
    //  定义公用参数
    protected $request;
    //  定义网站配置参数
    protected $validate_scene = [];
    protected $ImUser = [];
    protected $getdata = [];
    protected $webdb = [];
    protected $WebPublic = [];
    //  定义是否获取数据
    protected $ModelGetList = false;
    //  定义页面基础数据
    protected $list_base = [
        'page' => true,
    ];
    protected $list_file = [];
    protected $list_search = [];
    protected $list_nav = [];
    protected $space_name = 'home';

    public function __construct()
    {
        $this->request = request();
        $this->initialize();
    }
    protected function initialize(){
        if ($this->request->app != 'install'){
            $this->webdb = GetWebDb();
            $this->WebPublic = GetServer($this->webdb['public'],false);
            $this->webdb = GetServer($this->webdb);
            $this->ImUser = $this->request->ImUser;
        }

        $this->getdata = DataTrim($this->request->all());
        $this->getdata = DelNull($this->getdata);
        if(!empty($this->request->route?->param('id'))){
            $this->getdata['id'] = $this->request->route->param('id');
        }
        View::assign(['webdb' => $this->WebPublic,'imuser' => $this->ImUser]);
    }
    //  设置模板信息
    protected function SetView($data = []){
        $viewconf = config('view.options');
        $viewconf = array_merge($viewconf,$data);

        $app = $viewconf['app'];
        $defaultDir = $viewconf['default_dir'];
        //  定义模型目录
        $viewconf['tpl_replace_string']['__MOD__'] = "/{$app}/{$defaultDir}/images";
        $templateBasePath = "public/{$app}/{$defaultDir}/template";
        $viewconf['view_path'] = is_dir($templateBasePath) ? "{$templateBasePath}/" : "{$viewconf['view_path']}/default/template/";
        $viewconf['cache_path'] = rtrim($viewconf['cache_path'], '/') . "/{$app}/";

        return $viewconf;
    }
    protected $model;
    /**
     * 定义模型
     * @param $modelName 模型名称
     * @param $name 指定变量名称
     * @param $model 所属模块
     * @return void
     */
    protected function BaseModel($modelName = '',$name = 'model',$model = ''){
        $modelNamespace = $model ? "app\\{$model}\\model" : "app\\common\\model";
        if(empty($modelName)){
            $modelName = explode("\\",$this->request->controller);
            $modelName = end($modelName);
        }
        $_name = $modelNamespace . "\\" . $modelName;
        $this->$name = new $_name;
    }
    /**
     * 定义验证规则
     * @param string $validateName 验证器名称
     * @param string $validir   验证器路径
     */
    protected $validate;
    protected function BaseValidate($validateName = '',$validir = ''){
        $validir = empty($validir) ? 'app\common\validate' : 'app\\' . $validir .'\validate';
        if(empty($validateName)){
            $validateName = explode("\\",request()->controller);
            $validateName = end($validateName);
        }
        $validateName = $validir . '\\' . $validateName;
        $this->validate = new $validateName;
    }
    //  获取模板信息
    protected function GetViewFile($template = ''){
        $_request = request();
        $options = config('view.options');
        $template = implode('/',explode(':', $template));
        //  获取路径
        $path = public_path("/{$_request->viewconf['app']}/{$_request->viewconf['default_dir']}/template/");
        //  拼接模板地址
        $res = "{$path}{$template}.{$options['view_suffix']}";
        //  判断是否为移动端
        if($this->IsMobile() && is_file("{$path}mobile/{$template}.{$options['view_suffix']}")){
            $res = "{$path}mobile/{$template}.{$options['view_suffix']}";
        }
        if(!is_file($res)){
            $path = public_path("/{$_request->viewconf['app']}/{$options['default_dir']}/template/");
            $res = "{$path}{$template}.{$options['view_suffix']}";
            //  判断是否为移动端
            if($this->IsMobile() && is_file("{$path}mobile/{$template}.{$options['view_suffix']}")){
                $res = "{$path}mobile/{$template}.{$options['view_suffix']}";
            }
        }
        return ['code' => !is_file($res) ? '0' : '1','template' => $res];
    }
    //  判断是否为移动端
    protected function IsMobile(){
        $headers = $this->request->header();
        if(isset($headers['x-wap-profile'])){
            return true;
        } else if(isset ($headers['client']) && 'PhoneClient' == $headers['client']){
            return true;
        } else if(isset($headers['via']) && stristr($_SERVER['via'], 'wap')){
            return true;
        } else if(isset($headers['accept'])){
            if((strpos($headers['accept'], 'vnd.wap.wml') !== false) && (strpos($headers['accept'], 'text/html') === false || (strpos($headers['accept'], 'vnd.wap.wml') < strpos($headers['accept'], 'text/html')))){
                return true;
            }
        }
        if(isset($headers['user-agent'])){
            $clientkeywords = ['iphone','ipad','ipod','blackberry','android','netfront','symbian','ucweb','windowsce','palm','operamini','operamobi','openwave','nexusone','cldc','midp','wap','mobile'];
            if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($headers['user-agent']))) {
                return true;
            }
        }
        return false;
    }
    // 检测权限
    protected $user_auth = [
        'index' => false,
        'read' => false,
        'create' => false,
        'edit' => false,
        'del' => false,
    ];
    protected function CheckAuth($data,$model = '',$cname = ''){
        if(empty($cname)){
            $cname = explode('\\',$this->request->controller);
            $cname = end($cname);
        }
        if(empty($this->ImUser)){
            return [];
        }
        $res = Event::emit('auth.CheckAuth',['fid' => $this->ImUser['u_groupid'],'model' => $model ?: $this->space_name,'check' => $data,'cname' => $cname ?: $this->request->controller]);
        $this->user_auth = $res['0'];
        return $res['0'];
    }
    //  分配TDK
    protected function EditTdk($data = []){
        $this->WebPublic['web_title'] = empty($data['title']) ? $this->WebPublic['web_title'] : "{$data['title']}_{$this->WebPublic['web_title']}";
        $this->WebPublic['web_keywords'] = $data['keywords'] ?? $this->WebPublic['web_keywords'];
        $this->WebPublic['web_description'] = $data['description'] ?? $this->WebPublic['web_description'];
        View::assign(['webdb' => $this->WebPublic]);
    }
    //  检测是否登录
    protected function IsLogin(){
        return !empty($this->ImUser);
    }
    //  生成TOKEN
    protected function GetUserToken($user,$curtime = ''){
        $user['u_token_time'] = empty($curtime) ? time() : $curtime;
        $cheksum = utf8_encode(substr(SHA1($user['u_groupid'].$user['uid'].$user['u_name'].$user['u_token_time']),10,8));
        Cache::set($cheksum,$user,86400 * 7);
        return $cheksum;
    }
    //  验证token
    protected function CheckUserToken($token)
    {
        $res = Cache::get($token,[]);
        if(empty($res)){
            ResJson('TOKEN验证失败','10000');
        }
        $_token = $this->GetUserToken($res,$res['u_token_time'] ?? '');
        if($_token != $token){
            ResJson('TOKEN验证失败','10000');
        }
        $this->ImUser = $res;
        return true;
    }
}