<?php
declare(strict_types = 1);
namespace app\common\hook;

use Exception;
use InvalidArgumentException;
use RuntimeException;

class Upload
{
    protected $ResDir = '/upload_file';
    protected $ResLinshiDir = '/linshi';
    protected $UpDir;
    protected $LinshiDir;
    public function __construct(){
        $this->UpDir = public_path('upload_file');
        $this->LinshiDir = $this->UpDir.$this->ResLinshiDir;
        if (!file_exists($this->UpDir)) {
            @mkdir($this->UpDir,0755,true);
        }
        if (!file_exists($this->LinshiDir)) {
            @mkdir($this->LinshiDir,0755,true);
        }
    }
    //  查询文件是否存在
    public function CkFile($data){
        $filename = $data['name'];
        if($data['total'] > '1'){
            $prefix = "part{$data['index']}";
            $filename = "{$data['md5']}.{$prefix}";
        }
        if(is_file("{$this->LinshiDir}/{$filename}")){
            return [
                'title' => !empty($data['name']) ? $data['name'] : $filename,
                'size' => filesize($this->LinshiDir . '/' . $filename),
                'url' => $this->ResDir . $this->ResLinshiDir . '/' . $filename,
            ];
        }
        return false;
    }
    public function SetChUnk($data,$base = [])
    {
        if(!empty($base)){
            $prefix = "part{$base['index']}";
            if($base['total'] == '1'){
                $prefix = explode('.',$base['name']);
                $prefix = end($prefix);
                if($prefix == 'gz'){
                    $prefix = 'tar.' . $prefix;
                }
            }
            $name = "{$base['md5']}.{$prefix}";
        } else {
            // 获取文件后缀
            $suffix = $data->getUploadExtension();
            $name = md5($data->getUploadName()) . '.' . $suffix;
        }
        $setname = $this->LinshiDir . '/' . $name;

        $file = fopen($data->getRealPath(), 'r');
        $result = $this->putStream($setname, $file);
        if (is_resource($file)) {
            fclose($file);
        }

        $res = [
            'title' => $name,
            'size' => filesize($setname),
            'url' => $this->ResDir . $this->ResLinshiDir . '/' . $name,
        ];
        return $res;
    }
    //  写入文件
    public function putStream(string $path, $stream, array $options = []): bool
    {
        if (!is_resource($stream) || 'stream' !== get_resource_type($stream)) {
            throw new InvalidArgumentException('Invalid stream resource: expected stream resource');
        }
        $path = rtrim(str_replace('//', '/', $path), '/');
        $directory = dirname($path);
        if (!is_dir($directory)) {
            if (!@mkdir($directory, 0775, true) && !is_dir($directory)) {
                $error = error_get_last()['message'] ?? 'Unknown error';
                throw new RuntimeException("Directory creation failed: $directory ($error)");
            }
        }
        $tempDir = sys_get_temp_dir();
        $tempFile = tempnam($tempDir, 'php_');
        try {
            $target = fopen($tempFile, 'wb');
            if (false === stream_copy_to_stream($stream, $target)) {
                throw new RuntimeException("Stream copy failed for $path");
            }
            fclose($target);
            if (!rename($tempFile, $path)) {
                throw new RuntimeException("Atomic move failed for $path");
            }
            $mode = 0644;
            if (isset($options['visibility'])) {
                $mode = ($options['visibility'] === 'public') ? 0644 : 0600;
            }
            chmod($path, $mode);
            return true;
        } finally {
            if (is_resource($stream)) {
                fclose($stream);
            }
            if (file_exists($tempFile)) {
                unlink($tempFile);
            }
        }
    }
    //  合并文件
    public function PushFiles($data){
        $file_prefix = explode('.',$data['name']);
        $prefix = array_pop($file_prefix);
        if($prefix == 'gz'){
            $prefix = 'tar.' . $prefix;
        }
        $add_file = @fopen("{$this->LinshiDir}/{$data['md5']}.{$prefix}","a");
        for ($i = 0; $i < $data['total']; $i++) {
            $newv = fopen($this->LinshiDir . '/' . $data['md5'] . '.part' . $i,'r');
            flock($newv,LOCK_EX);
            fwrite($add_file,file_get_contents($this->LinshiDir . '/' . $data['md5'] . '.part' . $i));
            flock($newv,LOCK_UN);
            @unlink($this->LinshiDir . '/' . $data['md5'] . '.part' . $i);
        }
        @fclose($add_file);
        $res = array(
            'title' => $data['name'],
            'size' => filesize("{$this->LinshiDir}/{$data['md5']}.{$prefix}"),
            'url' => "{$this->ResDir}{$this->ResLinshiDir}/{$data['md5']}.{$prefix}"
        );
        return $res;
    }
    //  处理编辑器文件
    public function SetEditOr($data,$img_dir = '',$geturl = true){
        $oldimg = GetImgList($data['oldimg']);
        $newimg = GetImgList($data['newimg']);
        if(!empty($newimg)){
            $newimg = array_flip($newimg);
            $newimg = array_flip($newimg);
        }
        if(!empty($oldimg)){
            foreach ($oldimg as $v){
                $oldimgname[] = basename($v);
            }
        }
        //  处理新图片
        $newimgname = [];
        if(!empty($newimg)){
            foreach ($newimg as $k => $v){
                if(!empty($oldimgname)){
                    if(in_array(basename($v),$oldimgname)){
                        unset($newimg[$k]);
                    }
                }
                $newimgname[] = basename($v);
            }
        }
        //  处理老图片
        if(!empty($oldimg)){
            foreach ($oldimg as $k => $v){
                if(!empty($newimgname)){
                    if(in_array(basename($v),$newimgname)){
                        unset($oldimg[$k]);
                    }
                }
            }
        }
        //  检测目录是否存在
        $img_dir = $img_dir ?: date('Y-m');
        if(!file_exists($this->UpDir. '/' .$img_dir)){
            @mkdir($this->UpDir. '/' .$img_dir,0755,true);
        }
        //  开始移动
        if(!empty($newimg)){
            if($geturl == true){
                foreach ($newimg as $k => $v){
                    if(preg_match('/http:\/\/*\??[\w=&\+\%]*/is',$v) || preg_match('/https:\/\/*\??[\w=&\+\%]*/is',$v)){
                        $newname = $this->range($v,$img_dir);
                    }elseif(preg_match('/^(data:\s*image\/(\w+);base64,)/',$v,$type)){
                        $newname = $this->base64($v,$type,$img_dir);
                    }elseif(str_contains($v,"{$this->ResDir}/")){
                        $newname = $this->fileMove($v,$img_dir);
                    }
                    if(isset($newname)){
                        $data['newimg'] = str_ireplace($v,$newname,$data['newimg']);
                    }
                }
            }else{
                foreach ($newimg as $k => $v){
                    if(preg_match("{$this->ResDir}",$v)){
                        $newname = $this->fileMove($v,$img_dir);
                    }
                    if(isset($newname)){
                        $data['newimg'] = str_ireplace($v,$newname,$data['newimg']);
                    }
                }
            }
        }
        //  删除原有图片
        if(!empty($oldimg)){
            DelWebFile(FileEditAdd($oldimg,false));
        }
        return $data['newimg'];
    }
    /**
     * @param array|string $data 要处理的数据
     * @param string $file_dir 目标地址
     * @param string $moves 处理方式：copy为复制，rename为移动
     * @param bool $dels 是否删除源文件
     * @return array|string 返回文件地址
     */
    public function fileMove($data,$save = [],$moves = 'rename',$dels=true){
        if(is_array($data)){
            foreach ($data as $key => $val){
                $newdata[$key] = $this->fileMove($val,$save,$moves,$dels);
            }
            return $newdata;
        }
        if(empty($data)){
            return '';
        }
        //  查询当前用户
        $file_dir = empty($save['file_dir']) ? date('Y-m') : $save['file_dir'];
        /*重命名*/
        if(empty($save['file_name'])){
            $saveName = $this->newname($data);
            $fileFix = pathinfo((string) $data, PATHINFO_EXTENSION);
            $fileName = $saveName.'.'.$fileFix;
        } else {
            $fileName = $save['file_name'];
        }
        /*  检测文件夹是否存在 */
        if (!file_exists("{$this->UpDir}/{$file_dir}")) {
            @mkdir("{$this->UpDir}/{$file_dir}",0755,true);
        }
        /*移动文件*/
        if($moves == 'rename'){
            @rename(public_path().$data,$this->UpDir.'/'.$file_dir.'/'.$fileName);
        }else{
            @copy(public_path().$data,$this->UpDir.'/'.$file_dir.'/'.$fileName);
        }
        if($dels && $moves != 'rename'){
            @unlink(public_path().$data);
        }
        return $this->ResDir.'/'.$file_dir.'/'.$fileName;
    }
    /**
     * 定义新名称
     * @param $data
     * @return string
     */
    protected function newname($data){
        $imgmd5 = substr(md5($data.time()),0,8);
        $saveName = '';
        for ( $i = 0; $i < 10; $i++ ) {
            $saveName .= substr($imgmd5, mt_rand(0, strlen($imgmd5) - 1), 1);
        }
        return $saveName;
    }
    /**
     * 获取远程图片
     * @param $img
     * @param $imgurl
     * @return mixed|string
     */
    protected function range($img,$imgurl){
        // 1. 验证URL有效性
        if (!filter_var($img, FILTER_VALIDATE_URL)) {
            return $img;
        }
//halt([$this->UpDir,$imgurl]);
        // 2. 初始化cURL
        $ch = curl_init($img);
        if ($ch === false) {
            return $img;
        }
        $options = [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_MAXREDIRS => 5,
            CURLOPT_CONNECTTIMEOUT => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => false, // 生产环境应设为true
            CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
            CURLOPT_ENCODING => 'gzip, deflate',
            CURLOPT_HEADER => false
        ];
        curl_setopt_array($ch, $options);
        $imageData = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
        curl_close($ch);
        if ($httpCode !== 200 || !str_contains($contentType, 'image/')) {
            return $img;
        }

        $pathInfo = pathinfo(parse_url($img, PHP_URL_PATH));
        $newname = $this->newname($pathInfo['basename']);
        $newname .= '.' . $pathInfo['extension'];
        $dir = $this->UpDir . $imgurl;
        if (!is_dir($dir) && !mkdir($dir, 0755, true)) {
            return false;
        }
        if (file_put_contents("{$dir}/{$newname}", $imageData) === false) {
            return $img;
        }
        return "{$this->ResDir}/{$imgurl}/{$newname}";
    }
    /**
     * 保存BASE64图片
     * @param $img
     * @param $type
     * @param $imgurl
     * @return string
     */
    public function base64($img,$type,$imgurl){
        $imgpng = $type[2];
        $newname = $this->newname($img);
        $newname = $imgurl.'/'.$newname.'.'.$imgpng;
        if (!file_exists("{$this->LinshiDir}/{$imgurl}")) {
            @mkdir("{$this->LinshiDir}/{$imgurl}",0755,true);
        }
        file_put_contents("{$this->LinshiDir}/{$newname}", $img);
        return "/{$this->LinshiDir}/{$newname}";
    }
    public function SaveBase64($img,$img_dir = ''){
        $img_dir = empty($img_dir) ? date('Y-m',time()) : $img_dir;
        if (!file_exists($this->UpDir.$img_dir)) {
            @mkdir($this->UpDir,0777,true);
        }
        $base64_body = substr(strstr($img,','),1);
        $data = base64_decode($base64_body);
        preg_match('/^(data:\s*image\/(\w+);base64,)/',$img,$type);
        $res = $this->base64($data,$type,$img_dir);
        $res = [
            'url' => $res,
            'size' => filesize(public_path() . $res),
            'title' => basename($res),
        ];
        return $res;
    }

}