<?php
declare(strict_types = 1);
namespace app\hook\controller;

use support\Request;

class Piece extends Base
{
    protected static $icon = ['im-ego-box', 'im-address', 'im-fuzhi', 'im-fuzhi_o', 'im-fuzhi1', 'im-h5e', 'im-fanyi', 'im-fanyi1', 'im-ziyuan', 'im-xiaolian', 'im-celebration_door-sta', 'im-fanyi2', 'im-EAe', 'im-minshengbianmin', 'im-shenfenzhengguohui', 'im-douyin', 'im-douyin1', 'im-douyinzhanghao', 'im-erweima1688', 'im-lianjie', 'im-zidingyixieyi', 'im-CMS', 'im-zhedie-zhankai', 'im-zhedie-shouqi', 'im-guanbi', 'im-guanbi1', 'im-guanbi2', 'im-guanbi3', 'im-qiyeyewu', 'im-tubiao_qiyeguanli-copy', 'im-qiyeOA', 'im-fenxiang', 'im-fenxiang1', 'im-31dianzan', 'im-zhifubaodanse', 'im-zhifubao1', 'im-weixin1', 'im-qq', 'im-taobao', 'im-zhifubao2', 'im-weixin2', 'im-jiantou_shang', 'im-jiantou_you', 'im-jiantou_xia', 'im-jiantou_zuo', 'im-cangku', 'im-8', 'im-hexinxitong', 'im-hexin', 'im-anzhuoduanliulanqidakai', 'im-caidan', 'im-yaoqinghaibao', 'im-weiwangzhan', 'im-mingpianliebiao', 'im-icon-kaoshijilu', 'im-gengduo1', 'im-fenxi', 'im-APIwangguan', 'im-shangxian', 'im-dichengben', 'im-jiage', 'im-jiage1', 'im-diqufenxi', 'im-fenbianshuai', 'im-caozuoxitong', 'im-shenfenzhengzhengmian', 'im-zhifubao', 'im-aliyun', 'im-yingxiao', 'im-DNS-xiugai', 'im-dashuju', 'im-anquan', 'im-anquan1', 'im-shujukanban', 'im-jian', 'im-24gl-shieldWarning', 'im-anquan2', 'im-bianjie_fangbian', 'im-add', 'im-diannao', 'im-zanting', 'im-extend', 'im-yanjing1', 'im-tuichu', 'im-erji-zengzhifuwu', 'im-icon-1', 'im-kaifa', 'im-beian', 'im-jiankang', 'im-xiaochengxu', 'im-tubiaolunkuo-', 'im-xinyongqia', 'im-anquanwending', 'im-fuwuqi', 'im-shuaxin1', 'im-answer', 'im-app', 'im-browser', 'im-camera', 'im-cart', 'im-check', 'im-code', 'im-computer', 'im-copy', 'im-delete', 'im-deliver', 'im-display', 'im-down', 'im-download', 'im-edit', 'im-emoji', 'im-enclosure', 'im-eraser', 'im-favor', 'im-file', 'im-fill', 'im-fold', 'im-folder', 'im-font', 'im-hide', 'im-home', 'im-information', 'im-left', 'im-like', 'im-link', 'im-loading', 'im-lock', 'im-mail', 'im-mark', 'im-menu', 'im-message', 'im-minus', 'im-more', 'im-my', 'im-notification', 'im-order', 'im-person2', 'im-phone', 'im-record', 'im-refresh', 'im-rest', 'im-right', 'im-ringpause', 'im-rotate', 'im-roundcheck', 'im-search', 'im-service', 'im-shopping', 'im-sitting', 'im-tag', 'im-telephone', 'im-todown', 'im-toleft', 'im-toright', 'im-top', 'im-unfold', 'im-unlock', 'im-upload', 'im-video', 'im-kanxiaoguo', 'im-dianhua', 'im-dianhuajianpan', 'im-huchudianhua', 'im-gengduo', 'im-pinglun1', 'im-unie64d', 'im-screen', 'im-shimingrenzheng', 'im-iconfontfuwushichang', 'im-gerenshimingrz', 'im-tianjia', 'im-yuyin', 'im-yinlemusic214', 'im-qiandao', 'im-weixin', 'im-yuyue', 'im-youxiang', 'im-yanzhengma', 'im-zhengchang', 'im-caozuo', 'im-simqia', 'im-yonghuzu', 'im-querenfangan', 'im-xuanze', 'im-all', 'im-attachment', 'im-phone1'];

    public function index(Request $request){
        if(empty($this->getdata['n'])){
            ResJson('非法访问','0');
        }
        $res = $this->getdata['n'];
        return $this->$res();
    }
    //  查询图标
    protected function icon(){
        ResJson('获取成功','1',self::$icon);
    }
    /**
     * 查询模板
     * model 要查询的模块
     * fun 要查询的子目录
     * son 指定文件后缀
     * @throws \Exception
     */
    protected function template(){
        // 默认取对应模块下的模板目录
        $_dir = $this->getdata['model'];
        //  如果查询碎片文件，则读取对应目录
        $_dir = !empty($this->getdata['fun']) ? "{$_dir}/{$this->getdata['fun']}" : $_dir;
        //  读取目录文件
        $_temp = GetDirlist(public_path("{$_dir}"));
        //  查询要返回的文件后缀
        $_file = $this->getdata['son'] ?? 'php';
        $res = [];
        foreach ($_temp as $k => $v){
            $_v = $_dir == $this->getdata['model'] ? public_path("{$_dir}/{$v}/").$v . '.' . $_file : public_path("{$_dir}/") . $v;
            if(!is_file($_v)){
                continue;
            }
            $_vf = pathinfo($_v,PATHINFO_EXTENSION);
            if($_vf != $_file){
                continue;
            }
            if($_file == 'php'){
                $_v = require $_v;
                array_push($res,['title' => $_v['title'],'value' => $_v['path']]);
            } else {
                $_v = basename($_v,".{$_file}");
                array_push($res,['title' => $_v,'value' => $_v,'dir' => $this->getdata['fun']]);
            }
        }
        ResJson('获取成功','1',$res);
    }

    protected function getcode(){
        if(empty($this->getdata['name'])){
            ResJson('','非法访问','0');
        }
        if(!is_file(public_path($this->getdata['name']))){
            ResJson($this->getdata,'文件不存在','0');
        }
        $res = GetReadFile(public_path($this->getdata['name']));
        ResJson('查询成功','1',$res);
    }
}