<?php
declare(strict_types = 1);

namespace app\common\event;

use app\common\model\{Modular,ModularField,ModularMod};
use support\Cache;

class ModulMod
{
    private array $fieldCache = [];
    private array $modular = [];
    private array $mod = [];
    private array $filelist = [];

    /**
     * @param $data
     * @param $event_name
     * @return bool
     */
    public function Mod($data, $event_name)
    {
        $_fun = explode('.',$event_name);
        $_fun = end($_fun);
        if(!method_exists($this,$_fun)){
            return true;
        }
        return $this->$_fun($data);
    }
    //  后台获取模型列表
    protected function GetAdminList($data){
        $baseResult = $this->GetBase($data);
        if (!$baseResult['code']) return $baseResult;
        if (empty($this->fieldCache['adminlist'])) {
            $this->buildListCache();
        }
        return ['code' => '1', 'filelist' => $this->fieldCache['adminlist'], 'searchlist' => $this->fieldCache['search']];
    }
    //  后台获取模型表单
    protected function GetForm($data){
        $baseResult = $this->GetBase($data);
        if (!$baseResult['code']) return $baseResult;
        $this->initFieldCache();
        if (empty($this->fieldCache['adminform'])) {
            $this->fieldCache['adminform'] = $this->FormatFiled($this->filelist, 'adminform');
            $this->saveFieldCache();
        }
        return ['code' => '1','filelist' => $this->fieldCache['adminform']];
    }
    //  前台获取模型列表
    protected function GetHomeList($data){
        $filelist = $this->GetBase($data);
        if(empty($filelist['code'])){
            return $filelist;
        }
        $res = Cache::get("MOD_{$this->modular['name']}_{$this->mod['name']}_field") ?? [];
        if(empty($res['homelist'])) {
            //  获取列表字段
            $filelist = DelFile($this->filelist, 'list_show', '1');
            $filelist = $this->FormatFiled($filelist, 'homelist');

            $_pk = $this->GetModPk();
            $filelist = array_merge(
                [['field' => $_pk, 'title' => 'ID', 'default' => '', 'unit' => '']],
                $filelist
            );
            $filelist[] = ['field' => 'addtime', 'title' => '添加时间', 'default' => '', 'unit' => ''];
            $res['homelist'] = $filelist;
            Cache::set("MOD_{$this->modular['name']}_{$this->mod['name']}_field",$res);
        }
        return ['code' => '1','homelist' => $res['homelist']];
    }
    //  前台获取模型详情
    protected function GetHomeRead($data){
        $filelist = $this->GetBase($data);
        if(empty($filelist['code'])){
            return $filelist;
        }
        $res = Cache::get("MOD_{$this->modular['name']}_{$this->mod['name']}_field") ?? [];
        if(empty($res['homeread'])) {
            //  获取字段
            $filelist = $this->FormatFiled($this->filelist, 'read');

            $_pk = $this->GetModPk();
            $filelist = array_merge(
                [['field' => $_pk, 'title' => 'ID', 'type' => 'hidden', 'default' => '', 'unit' => '']],
                $filelist
            );
            $filelist[] = ['field' => 'addtime', 'title' => '添加时间', 'default' => '', 'unit' => ''];
            $res['homeread'] = $filelist;
            Cache::set("MOD_{$this->modular['name']}_{$this->mod['name']}_field",$res);
        }
        return ['code' => '1','homeread' => $res['homeread']];
    }
    //  后台获取模型列表
    protected function GetMemberList($data){
        $baseResult = $this->GetBase($data);
        if (!$baseResult['code']){
            return $baseResult;
        }
        if (empty($this->fieldCache['adminlist'])) {
            $this->buildListCache();
        }
        return ['code' => '1', 'filelist' => $this->fieldCache['adminlist'], 'searchlist' => $this->fieldCache['search']];
    }
    //  查询模型
    protected function GetMod($data){
        $mod = $this->GetBase($data);
        if(empty($mod['code'])){
            return $mod;
        }
        return ['code' => '1','data' => $this->mod];
    }
    //  查询基本信息
    protected function GetBase($data){
        // 检查模块
        $this->modular = $this->CheckModular($data['model']);
        if (empty($this->modular)) {
            return ['code' => '0','msg' => '模块不存在或已禁用'];
        }
        // 检查模型
        $this->mod = $this->CheckMod($data['mod']);
        if (empty($this->mod)) {
            return ['code' => '0','msg' => '模型不存在或已禁用','data' => ''];
        }
        // 获取字段
        $this->filelist = $this->CheckFile();
        if (empty($this->filelist)) {
            return ['code' => '0','msg' => '暂无字段，请先创建字段','data' => ''];
        }
        // 初始化字段缓存
        $this->initFieldCache();
        return ['code' => '1','msg' => '查询成功'];
    }
    //  查询模块信息
    protected function CheckModular($modularname){
        static $staticCache = [];
        if (isset($staticCache[$modularname])) {
            return $staticCache[$modularname];
        }
        $res = Cache::get("MODULAR") ?: [];
        if (empty($res[$modularname])) {
            $_m = new Modular();
            $_res = $_m->GetList(['name' => $modularname, 'status' => '1', 'GetFile' => 'id,title,name,status'], false);
            if (!empty($_res)) {
                $_res = $_m->UntList($_res);
                $res[$modularname] = $_res[0] ?? [];
                if (!empty($res[$modularname])) {
                    Cache::set("MODULAR", $res);
                }
            }
        }
        $staticCache[$modularname] = $res[$modularname] ?? [];
        return $staticCache[$modularname];
    }
    //  查询模型信息
    protected function CheckMod($modname){
        static $staticCache = [];
        // 转换模型名称为小写
        $modname = strtolower($modname);
        $cacheKey = "{$this->modular['name']}_{$modname}";
        if (isset($staticCache[$cacheKey])) {
            return $staticCache[$cacheKey];
        }
        $res = Cache::get("MOD_{$this->modular['name']}") ?: [];
        if (empty($res[$modname])) {
            $_m = new ModularMod();
            $_res = $_m->GetList(['fid' => $this->modular['id'], 'name' => $modname, 'status' => '1', 'GetFile' => 'id,fid,title,name,status,open,name_key,pages,list_order,see_sort,see_addtime,see_addip'], false);
            if (!empty($_res)) {
                $_res = $_m->UntList($_res);
                $res[$modname] = $_res[0] ?? [];
                if (!empty($res[$modname])) {
                    Cache::set("MOD_{$this->modular['name']}", $res);
                }
            }
        }

        $staticCache[$cacheKey] = $res[$modname] ?? [];
        return $staticCache[$cacheKey];
    }
    //  查询模型字段
    protected function CheckFile(){
        $this->initFieldCache();
        if (empty($this->fieldCache['zone'])) {
            $_m = new ModularField();
            $this->fieldCache['zone'] = $_m->GetList(['fid' => $this->mod['id'], 'status' => '1', 'GetFile' => 'id,fid,title,field,type,required,required_list,default,list,unit,tip,sort,geturl,fielddata,gettype,list_show,search_show,group,getclass,getmodel'], false);
            if (!empty($this->fieldCache['zone'])) {
                $this->fieldCache['zone'] = $_m->UntList($this->fieldCache['zone']);
                $this->saveFieldCache();
            }
        }
        return $this->fieldCache['zone'] ?: [];
    }
    //  标准化字段
    protected function FormatFiled($data,$type = 'form'){
        $typeHandlers = [
            'adminform' => fn(&$v) => $this->FormFields($v, $type),
            'adminlist' => fn(&$v) => $this->ListFields($v, $type),
            'memberlist' => fn(&$v) => $this->ListFields($v, $type),
            'homelist' => fn(&$v) => $this->ListFields($v, $type),
            'search' => fn(&$v) => $this->ListFields($v, $type),
            'read' => fn(&$v) => $this->ReadFields($v),
        ];
        foreach ($data as &$v) {
            // 统一处理字段类型
            if (in_array($v['type'], ['select', 'radio'])) {
                $this->processOptionFields($v);
            }
            unset($v['id'], $v['fid'], $v['sort']);
            // 按类型处理
            if (isset($typeHandlers[$type])) {
                $typeHandlers[$type]($v);
            }
        }
        return $data;
    }
    //  查询数据表主键
    protected function GetModPk(){
        //  查询主键
        $_m = 'app\\' . $this->mod['fid_name'] ."\\model\\" . $this->mod['name_key'];
        $_m = new $_m;
        return $_m->getPk();
    }
    /**
     * 初始化字段缓存
     */
    private function initFieldCache() {
        $cacheKey = "MOD_{$this->modular['name']}_{$this->mod['name']}_field";
        $this->fieldCache = Cache::get($cacheKey) ?: [];
    }

    /**
     * 保存字段缓存
     */
    private function saveFieldCache() {
        $cacheKey = "MOD_{$this->modular['name']}_{$this->mod['name']}_field";
        Cache::set($cacheKey, $this->fieldCache);
    }
    /**
     * 构建列表缓存
     */
    private function buildListCache() {
        $filelist = $this->FormatFiled(DelFile($this->filelist, 'list_show', '1'),'adminlist');
        $_pk = $this->GetModPk();
        $this->fieldCache['adminlist'] = array_merge([['field' => $_pk, 'title' => 'ID', 'width' => '80', 'textalign' => 'center', 'fixed' => 'left']], $filelist);
        if ($this->mod['see_sort'] ?? false) {
            $this->fieldCache['adminlist'][] = ['field' => 'sort', 'title' => '排序', 'type' => 'text', 'textalign' => 'center', 'width' => '100'];
        }
        $this->fieldCache['adminlist'][] = ['field' => 'status', 'title' => '状态', 'type' => 'radio', 'list' => ['草稿','启用','禁用'], 'textalign' => 'center', 'width' => '100', 'default' => '1'];
        if ($this->mod['see_addtime'] ?? false) {
            $this->fieldCache['adminlist'][] = ['field' => 'addtime', 'title' => '添加时间', 'type' => 'text', 'textalign' => 'center', 'width' => '180'];
        }
        if ($this->mod['see_addip'] ?? false) {
            $this->fieldCache['adminlist'][] = ['field' => 'addip', 'title' => '添加IP', 'type' => 'text', 'textalign' => 'center', 'width' => '150'];
        }
        $this->fieldCache['search'] = $this->FormatFiled(DelFile($this->filelist, 'search_show', '1'), 'search');
        $this->saveFieldCache();
    }
    /**
     * 处理选项型字段（select/radio）
     */
    private function processOptionFields(&$field) {
        if ($field['type'] === 'select') {
            $field['text'] = true;
        }

        if (!empty($field['list'])) {
            $this->normalizeOptionList($field['list']);
        }
    }
    /**
     * 规范化选项列表
     */
    private function normalizeOptionList(&$options) {
        $options = array_map(function($item) {
            $parts = explode('|', trim($item));
            if (count($parts) >= 2) {
                return ['value' => trim($parts[0]), 'title' => trim($parts[1])];
            }
            return ['value' => $item, 'title' => $item];
        }, explode("\n", str_replace(["\r\n", "\r"], "\n", $options)));
    }
    /**
     * 处理列表字段
     */
    private function ListFields(&$field, $type) {
        unset($field['required'], $field['required_list'], $field['tip'],$field['gettype'], $field['group'], $field['list_show'], $field['search_show']);
        if ($type === 'search' && $field['type'] === 'radio') {
            $field['type'] = 'select';
        }
    }
    /**
     * 处理显示字段
     */
    private function FormFields(&$field,$type) {
        unset($field['list_show'],$field['search_show']);
    }
    /**
     * 处理显示字段
     */
    private function ReadFields(&$field) {
        unset($field['required'], $field['required_list'],$field['tip'],$field['group'],$field['list_show'],$field['search_show']);
    }
}