<?php
declare(strict_types = 1);
namespace app\common\middleware;

use support\Container;
use Webman\MiddlewareInterface;
use Webman\Http\Response;
use Webman\Http\Request;

class Base implements MiddlewareInterface
{

    public function process(Request $request, callable $handler): Response
    {
        //  检测应用是否允许访问
        $res = $this->prohibit($request->app);
        if (!$res){
            throw new \Exception(json_encode(['code' => '0', 'msg' => '页面走失了'], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES),404);
        }
        //  检测是否安装
        if(!is_file(app_path('app.lock')) && $request->app != 'install'){
            ResRedirect(route('install.Index.index'),'0','系统未安装');
        } else if($request->app != 'install') {
            // 检测安装文件是否存在，如果存在则删除
            if(is_dir(app_path('install'))){
                DelDir(app_path('install'));
            }
            if(is_dir(base_path('public/home/install'))){
                DelDir(base_path('public/home/install'));
            }
            $session = $request->session();
            $request->ImUser = $session->get('userdb',[]);
            if($session->has('_eru_') && !$session->has('userdb')){
                $session->delete('_eru_');
                $request->ImUser = [];
            }
            if(!empty($request->ImUser)){
                if($session->has('_eru_')){
                    $session->set('_eru_',$session->get('_eru_'));
                }
                $session->set('userdb',$request->ImUser);
            }
            //  检测是否登录后台
            $request->webonclick = $session->has('_eru_') ? 'ery-bodydbclick' : '';
            $request->Label = $session->get('_label_',false);
        }
        //  执行控制器方法
        $response = $handler($request);
        return $response;
    }
    //  检测应用是否允许访问
    protected function prohibit($AppName){
        $prohibit = config('app.prohibit_app_list');
        return !in_array($AppName,$prohibit);
    }

}