<?php
declare(strict_types = 1);
namespace app\common\model;

use support\Cache;
use support\think\Model;
use think\facade\Db;

class R extends Model
{
    protected $filed_list = [];
    protected $autoWriteTimestamp = false;   // 自动写入时间戳
    //  格式化数据
    public function EditAdd($data){
        $this->GetTableFileList($data);
        if(!empty($this->filed_list['data'][$this->getPk()])){
            unset($this->filed_list['data']['addtime'],$this->filed_list['data']['addip']);
        }else{
            if(in_array('addtime',$this->filed_list['filedlist'])){
                $this->filed_list['data']['addtime'] = date('Y-m-d H:i:s');
            }
            if(in_array('addip',$this->filed_list['filedlist'])){
                $this->filed_list['data']['addip'] = empty($data['addip']) ? request()->getRealIp(false) : $data['addip'];
            }
        }
        if(in_array('edittime',$this->filed_list['filedlist'])){
            $this->filed_list['data']['edittime'] = date('Y-m-d H:i:s');
        }
        if(in_array('editip',$this->filed_list['filedlist'])){
            $this->filed_list['data']['editip'] = request()->getRealIp(false);
        }
        if(in_array('ropt',$this->filed_list['filedlist'])){
            $this->filed_list['data']['ropt'] = request()->getRemotePort();
        }
        if(method_exists($this,'EditAddCallback')){
            $this->EditAddCallback($data);
        }
        return $this->filed_list['data'];
    }
    /**
     * 设置查询条件
     * @param $data
     * @return R|\think\db\Query
     */
    protected function TableWhere($data){
        //  是否禁止使用默认查询
        $_CheckFu = !empty($data['_CheckFu']);
        //  清除空字段
        $data = DelNull($data);
        //  获取查询条件
        $this->GetTableFileList($data);
        //  按条件查询数据
        $map = method_exists($this,'GetListFu') ? $this->GetListFu($data) : $this;
        if(!empty($this->filed_list['data']) && !$_CheckFu){
            foreach ($this->filed_list['data'] as $k => $v){
                if($k == 'status' && !empty($v) && $v == 'a'){
                    continue;
                }
                if(is_array($v)){
                    if(count($v) < 1){
                        continue;
                    }
                    $_continue = false;
                    switch ($v['0']) {
                        case 'in':
                        case 'like':
                            $v['1'] = $v['0'] == 'like' ? "%{$v['1']}%" : $v['1'];
                            $map = $map->where($k, $v['0'], $v['1']);
                            $_continue = true;
                            break;
                        case 'raw':
                            $map = $map->whereRaw($v['1']);
                            $_continue = true;
                            break;
                    }
                    if ($_continue) {
                        continue;
                    }
                }
                $map = $map->whereIn($k, is_array($v) ? $v : (string)$v);
            }
        }
        if(in_array('del_time',$this->filed_list['filedlist'])){
            if(!empty($data['getdel'])){
                $map = $map->whereNotNull('del_time');
            }else{
                $map = $map->whereNull('del_time');
            }
        }
        if(!empty($data['key'])){
            $_filedjob = DelFile($this->filed_list['filedjob'],'_type',['int','datetime','date','tinyint'],true);
            $_filedjob = array_column($_filedjob,'Field');
            $_sofiled = implode('|',$_filedjob);
            $map = $map->whereLike($_sofiled,"%{$data['key']}%");
        }
        if(!empty($data['GetFile'])){
            $data['GetFile'] = is_array($data['GetFile']) ? $data['GetFile'] : explode(',',$data['GetFile']);
            if(!in_array($this->getPk(),$data['GetFile'])){
                array_push($data['GetFile'],$this->getPk());
            }
            $map = $map->field($data['GetFile']);
        }
        if(!empty($data['GetTimes'])){
            if(!empty($data["{$data['GetTimes']}_add"])){
                $map = $map->whereTime($data['GetTimes'],'>=',$data["{$data['GetTimes']}_add"]);
            }
            if(!empty($data["{$data['GetTimes']}_end"])){
                $map = $map->whereTime($data['GetTimes'],'<=',$data["{$data['GetTimes']}_end"]);
            }
            if(!empty($data["{$data['GetTimes']}_d"])){
                if($data["{$data['GetTimes']}_d"] == 'd'){
                    $map = $map->whereDay($data['GetTimes']);
                } else {
                    $map = $map->whereDay($data['GetTimes'],$data["{$data['GetTimes']}_d"]);
                }
            }
            if(!empty($data["{$data['GetTimes']}_m"])){
                if($data["{$data['GetTimes']}_m"] == 'm'){
                    $map = $map->whereMonth($data['GetTimes']);
                } else {
                    $map = $map->whereMonth($data['GetTimes'],$data["{$data['GetTimes']}_m"]);
                }
            }
            if(!empty($data["{$data['GetTimes']}_y"])){
                if($data["{$data['GetTimes']}_y"] == 'y'){
                    $map = $map->whereYear($data['GetTimes']);
                } else {
                    $map = $map->whereYear($data['GetTimes'],$data["{$data['GetTimes']}_y"]);
                }
            }
            if(!empty($_times)){
                $map = $map->whereTime($data['GetTimes'],$_times);
            }
        }
        $_order = empty($this->_order) ? "{$this->getPk()} desc" : $this->_order;
        $map = empty($data['order']) ? $map->order($_order) : $map->order($data['order']);
        return $map;
    }
    public function GetFieldList(){
        $this->GetTableFileList();
        $filedjob = $this->filed_list['filedjob'];
        return $filedjob;
    }
    /**
     * 获取数据列表，根据参数进行筛选，如果存在软删除，则不返回软删除数据
     * ** 特殊变量
     * ** _CheckFu bool 如果为true 则必走附加查询方法
     * @param array $data 筛选参数
     * @param bool $pages 是否分页
     * @return array|mixed 返回结果
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function GetList($data = [],$pages = true){

        //  如果参数携带禁止分页，则强制不分页
        if(isset($data['pages']) && empty($data['pages'])){
            $pages = false;
        }
        $map = $this->TableWhere($data);
        if($pages){
            $limit = [
                'list_rows' => empty($data['limit']) ? '20' : $data['limit']
            ];
            if(!empty($data['page'])){
                $limit['page'] = $data['page'];
            }
            $getlist = $map->paginate($limit);
            $getlist = JobArray($getlist);
        } else {
            $getlist = $map->select()->toArray();
        }
        return $getlist;
    }
    /**
     * 查询统计数据
     */
    public function CountList($data){
        $map = $this->TableWhere($data);
        if(!empty($data['table_group'])){
            $map = $map->field($data['table_group'])->group($data['table_group']);
        }
        if(!empty($data['table_distinct'])){
            $map = $map->distinct(true)->field($data['table_distinct']);
        }
        return match($data['table_type'] ?? null){
            'column' => $map->column($data['column']),
            'sum' => $map->sum($data['sum']),
            'count' => $map->count($data['count'] ?? $this->getPk()),
            'max' => $map->max($data['max'] ?? 'id'),
            default => $map->select()->toArray()
        };
    }
    /**
     * @param $id
     * @param bool $unt 是否需要格式化
     * @return array|mixed 返回数组，如不存在，则返回空数组
     */
    public function GetOne($id = '',$unt = true,$field = ''){
        $_pk = empty($field) ? $this->getPk() : $field;
        $res = empty($id) ? $this->order("{$_pk} desc")->find() : $this->where($_pk,$id)->find();
        $res = empty($res) ? [] : $res->toArray();
        if($unt && !empty($res)){
            $res = $this->UntList([$res]);
            $res = $res['0'];
        }
        if(method_exists($this,'GetOneCallback')){
            $res = $this->GetOneCallback($res);
        }
        return $res;
    }
    /**
     * @param $id
     * @return array|mixed 返回原始数据，如不存在则返回空数组
     */
    public function EditOne($id,$field = ''){
        $res = $this->GetOne($id,false,$field);
        if(method_exists($this,'EditOneCallback')){
            $res = $this->EditOneCallback($res);
        }
        return $res;
    }
    /**
     * 保存数据
     * @param $data
     * @return array|false|mixed
     */
    public function SetOne($data){
        $_pk = $this->getPk();
        if(method_exists($this,'SetOneSelf')){
            $data = $this->SetOneSelf($data);
        }
        if(empty($data[$_pk])){
            if(!$add = $this->create($data)){
                return false;
            }
        }else{
            if(!$this->where($_pk,$data[$_pk])->update($data)){
                return false;
            }
        }
        $res = $this->GetOne(empty($data[$_pk]) ? $add->$_pk : $data[$_pk],false);
        if(method_exists($this,'SetOneCallback')){
            $res = $this->SetOneCallback($res,empty($data[$_pk]));
        }
        return $res;
    }
    /**
     * 删除数据
     * @param array|string $data
     */
    public function DelData($data){
        $this->GetTableFileList();
        if(in_array('del_time',$this->filed_list['filedlist'])){
            $_dellist = $this->whereIn($this->getPk(),is_array($data) ? $data : (string) $data)->select()->toArray();
            $_deltime = array_unique(array_column($_dellist,'del_time'));
            if(count($_deltime) > 0){
                $_dellist = DelNull($_dellist);
                $_deltime = array_column($_dellist,$this->getPk());
                $this->whereIn($this->getPk(),$_deltime)->update(['del_time' => date('Y-m-d H:i:s'),'status' => '0']);
                if(method_exists($this,'DelCallback')){
                    return $this->DelCallback($_dellist);
                }
                return true;
            }
        }
        $this->destroy($data);
        if(method_exists($this,'DelCallback')){
            return $this->DelCallback($_deltime);
        }
        return true;
    }
    /**
     * 解压数据
     * @param $data
     * @return mixed
     */
    public function UntList($data){
        if(count($data) < '1' || !method_exists($this,'UntModel')){
            return $data;
        }
        return $this->UntModel($data);
    }
    /**
     * 数据清洗，过滤数据表没有的字段，返回字段列表及清洗结果
     * [filedlist => 字段列表，data => 清洗结果]
     * @param array $data
     */
    protected function GetTableFileList($data = []){
        if(Cache::has("SQLFILED_{$this->getName()}")){
            $filed_list = Cache::get("SQLFILED_{$this->getName()}");
        } else {
            $filed_list = Db::query("SHOW FULL COLUMNS FROM {$this->getTable()}");
            foreach ($filed_list as &$v) {
                $type = explode('(', $v['Type']);
                $v['_type'] = $type[0];
            }
            Cache::set("SQLFILED_{$this->getName()}",$filed_list);
        }
        $_filed_list = array_column($filed_list,'Field');
        $res = [];
        if(!empty($data)){
            unset($v);
            foreach ($_filed_list as $k => $v){
                if (array_key_exists($v,$data)) {
                    $res[$v] = $data[$v];
                }
            }
        }
        $this->filed_list = [
            'filedjob' => $filed_list,
            'filedlist' => $_filed_list,
            'data' => $res,
        ];
    }
}