layui.define(function(exports){
    const layer = layui.layer,
        laytable = layui.table,
        laydate = layui.laydate,
        treeTable = layui.treeTable,
        layform = layui.form;
    const ECms = new EruCms();
    const getSafeValue = (obj, prop, defaultValue = '') => {
            return (obj && obj[prop] !== undefined) ? obj[prop] : defaultValue;
        },
        safeToString = (value, defaultValue = '') => {
            return value != null ? value.toString() : defaultValue;
        },
        EditUrl = (url,data) => {
            return url.replace(/__(\w+)__/g, (match, field) => {
                const fieldName = field.trim();
                // 检查变量是否存在
                if (!Object.prototype.hasOwnProperty.call(data, fieldName)) {
                    return '';
                }
                const value = data[fieldName];
                // 处理未定义和null值
                if (value === undefined || value === null) {
                    return '';
                }
                // 安全转换为字符串并进行URL编码
                return encodeURIComponent(String(value));
            });
        },
        handleEditType = (res, data) => {
            res.edit = 'text';
            return res;
        },
        handleSelectOrRadioType = (res, data) => {
            if (!data.list) {
                return res;
            }
            const valueMap = new Map();
            data.list.forEach((item, index) => {
                const key = safeToString(item.value ?? index),
                    displayValue = getSafeValue(item, 'title', item);
                if (!valueMap.has(key)) {
                    valueMap.set(key, displayValue);
                }
            });
            res.templet = (rowData) => {
                const rawValue = getSafeValue(rowData, res.field),
                    rowValue = safeToString(rawValue);
                if (rowValue == null) return '';
                const displayValue = valueMap.get(rowValue);
                return displayValue || '';
            };
            return res;
        },
        handleCheckboxType = (res, data) => {
            if (!data.list) {
                res.type = 'checkbox';
                return res;
            }
            res.type = 'text';
            res.templet = (rowData) => {
                const selectedValues = safeToString(getSafeValue(rowData, data.field, '')).split(','),
                    list = getSafeValue(data, 'list', []),
                    matchedValues = list.filter(item => {
                        const itemValue = safeToString(getSafeValue(item, 'value', list.indexOf(item).toString()));
                        return selectedValues.includes(itemValue);
                    }).map(item => getSafeValue(item, 'title', item));
                return matchedValues.join(', ');
            };
            return res;
        },
        handleSwitchType = (res, data) => {
            res.templet = (rowData) => {
                const rowValue = safeToString(getSafeValue(rowData, res.field)),
                    defaultValue = safeToString(getSafeValue(data, 'default')),
                    isChecked = rowValue === defaultValue,
                    isDisabled = safeToString(getSafeValue(data, 'disabled')) === '1',
                    fieldEdit = getSafeValue(data, 'field_edit', data.field),
                    pkValue = safeToString(getSafeValue(rowData, data.pk, '')),
                    allowedList = getSafeValue(data, 'list'),
                    isInList = !allowedList || (rowValue && allowedList.includes(rowValue));

                if (!isInList) {
                    return '';
                }
                // 构建开关HTML
                return `<input type="checkbox" name="${res.field}" value="${pkValue}" lay-skin="switch" data-id="${data.pk}" lay-text="${getSafeValue(data, 'text')}" lay-filter="*" ${isChecked ? 'checked' : ''} ${isDisabled ? 'disabled' : ''}>`;
            };
            return res;
        },
        handleButtonType = (res, data) => {
            // 设置按钮基本属性
            const title = getSafeValue(data, 'title', ''),
                openTitle = getSafeValue(data, 'opentitle', title),
                icon = getSafeValue(data, 'icon') ? `<i class="ery-icon ${data.icon}"></i>` : '',
                text = getSafeValue(data, 'text', false),
                btnTitle = text ? `${icon}<span class="ery-mag-l5">${title}</span>` : icon,
                openAttr = data.open ? ` data-type='OpenWind' data-title="${openTitle}"` : '',
                fullAttr = data.full ? ` data-full='${data.full}'` : '',
                tipAttr = data.tip ? ` data-tip='${data.tip}'` : '',
                reloadAttr = safeToString(getSafeValue(data, 'reload')) === '0' ? ` data-reload='0'` : '';

            let btnClass = getSafeValue(data, 'class', 'ery-button-s ery-bg-green');
            if (data.open) {
                btnClass += ' ery-click';
            }
            // 添加事件处理类
            if (data.event) {
                res.event = data.event;
                btnClass += ` _${data.event}`;
            }
            // 创建按钮HTML
            res.templet = (rowData) => {
                const resUrl = EditUrl(getSafeValue(data, 'url'), rowData),
                    fieldEdit = getSafeValue(data, 'field_edit', data.field),
                    rowValue = safeToString(getSafeValue(rowData, fieldEdit, '')),
                    // 确定是否在允许列表中
                    allowedList = getSafeValue(data, 'list'),
                    isInList = !allowedList || (rowValue && allowedList.includes(rowValue));
                if (!isInList) {
                    return '';
                }
                // 确定URL属性
                const urlAttr = (data.open || data.event) ? ` data-url='${resUrl}'` : ` href='${resUrl}'`,
                    targetAttr = data.target ? ` target="${data.target}"` : ``;
                return `<a class="${btnClass}" ${urlAttr} ${tipAttr} ${openAttr} ${fullAttr} ${reloadAttr} ${targetAttr}>${btnTitle}</a>`;
            };
            return res;
        },
        handleIconType = (res, data) => {
            res.templet = (rowData) => {
                const iconClass = getSafeValue(rowData, data.field, ''),
                    additionalClass = getSafeValue(data, 'class', '');
                return `<i class="${iconClass} ${additionalClass}"></i>`;
            };
            return res;
        },
        handleImageType = (res, data) => {
            res.templet = (rowData) => {
                const imgSrc = getSafeValue(rowData, data.field, '');
                return `<img src="${imgSrc}" class="ery-img-responsive" alt="">`;
            };
            return res;
        },
        handleDateType = (res, data) => {
            res.templet = (rowData) => {
                const dateValue = getSafeValue(rowData, data.field);
                return EditDates(dateValue, 'datetime');
            };
            return res;
        },
        handleMoneyType = (res, data) => {
            res.templet = (rowData) => {
                let moneyValue = getSafeValue(rowData, data.field);
                if (data.adddel) {
                    const addType = safeToString(getSafeValue(rowData, 'add_type_del')),
                        colorClass = addType === '1' ? 'ery-text-green' : 'ery-text-red',
                        sign = addType === '1' ? '- ' : '+ ';
                    moneyValue = `<span class="${colorClass}">${sign}${moneyValue}</span>`;
                }
                return moneyValue;
            };
            return res;
        },
        handleListType = (res, data) => {
            res.type = 'normal';
            res.templet = (rowData) => {
                const listData = getSafeValue(rowData, data.field, []),
                    typeField = getSafeValue(data, 'type_field');
                return listData.map(item => typeField ? getSafeValue(item, typeField) : item).join(', ');
            };
            return res;
        },
        handleDefaultType = (res, data) => {
            res.type = 'normal';
            if (data.list) {
                res.templet = (rowData) => {
                    const rowValue = safeToString(getSafeValue(rowData, data.field));
                    const valueField = getSafeValue(data, 'type_field', data.field);
                    if (!rowValue || !data.list.includes(rowValue)) {
                        return '';
                    }
                    return getSafeValue(rowData, valueField);
                };
            }
            return res;
        },
        TableType = (res, data) => {
            const type = getSafeValue(data, 'type', 'default'),
                // 调用对应的类型处理器
                typeHandlers = {
                    'edit': handleEditType,
                    'select': handleSelectOrRadioType,
                    'radio': handleSelectOrRadioType,
                    'checkbox': handleCheckboxType,
                    'switch': handleSwitchType,
                    'btn': handleButtonType,
                    'icon': handleIconType,
                    'image': handleImageType,
                    'date': handleDateType,
                    'money': handleMoneyType,
                    'list': handleListType,
                    'default': handleDefaultType
                },
                handler = typeHandlers[type] || handleDefaultType;
            res.type = type === 'default' ? 'normal' : res.type;
            return handler(res, data);
        };
    // 处理表单
    const InputBase = (data) => {
            // 使用解构赋值简化数据访问
            const {
                type: initType = 'text',
                title: titleEdit = '',
                field = '',
                default: defaultValue = '',
                type_edit,
                required,
                disabled,
                readonly,
                min,
                max,
                step,
                minlength,
                maxlength,
                inputmode,
                enterkeyhint
            } = data || {};
            title = titleEdit || title;
            // 基础配置
            const conf = {
                type: type_edit || initType,
                placeholder: `请输入${title || ''}`,
                id: field,
                name: field,
                value: defaultValue,
            };
            // 状态相关属性（使用空字符串作为布尔属性值）
            if (required) conf.required = 'required';
            if (required) conf['lay-verify'] = 'required';
            if (disabled) conf.disabled = 'disabled';
            if (readonly) conf.readonly = 'readonly';

            // 数值相关属性
            if (min !== undefined) conf.min = min;
            if (max !== undefined) conf.max = max;
            if (step !== undefined) conf.step = step;

            // 文本长度属性
            if (minlength !== undefined) conf.minlength = minlength;
            if (maxlength !== undefined) conf.maxlength = maxlength;

            // 输入法相关属性
            if (inputmode) conf.inputmode = inputmode;
            if (enterkeyhint) conf.enterkeyhint = enterkeyhint;

            return conf;
        },
        InputText = (data) => {
            return Object.entries(data).reduce((str, [key, value]) => {
                // 处理特殊键值对（lay-verify 等含连字符的属性）
                const attrKey = /-/.test(key) ? key : key.toLowerCase();
                if (value == null || value === '') return str;
                const escapedValue = typeof value === 'string' ? value.replace(/"/g, '&quot;') : value;
                return typeof value === 'boolean' && value ? `${str} ${attrKey}` : `${str} ${attrKey}="${escapedValue}"`;
            }, '');
        },
        InputField = (res) => {
            const {unit} = res,
                unitMarkup = unit ? `<div class="ery-ipt-icon ery-bg-white-1">${unit}</div>` : '',
                inputStyle = unit ? `style='border-radius: 4px 0 0 4px;'` : '';
            let _conf = InputBase(res);
            let inputElement = InputText(_conf);
            if (res.type === 'textarea') {
                inputElement = `<textarea class="ery-ipt" rows="4" ${inputElement} ${inputStyle}>${res.default}</textarea>`;
            } else {
                inputElement = `<input class="ery-ipt" ${inputElement} ${inputStyle}>`;
            }
            return unit ? `<div class="layout ery-form-itemnowarp">${inputElement}${unitMarkup}</div>` : inputElement;
        },
        DatePicker = (res, isDatetime = false) => {
            const { field, title, required, disabled, default: defaultValue } = res,
                titleText = res.title_edit || title,
                value = defaultValue != null ? defaultValue : '',
                type = isDateTime ? 'datetime' : 'date',
                requiredAttr = required ? `required='true' lay-verify='required'` : '',
                disabledAttr = disabled ? `disabled='true'` : '',
                verifyAttr = res.required_list ? `lay-verify='${res.required_list}'` : '';
            return `<input class="ery-ipt" placeholder="请选择${titleText}" type="text" name="${field}" value="${value}" id="${field}" ${requiredAttr} ${verifyAttr} ${disabledAttr}>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                layui.use('laydate', function() {
                    const laydate = layui.laydate;
                    laydate.render({
                        elem: '#${field}',
                        type: '${type}',
                    });
                });
            });
        </script>`;
        },
        RadioGroup = (data) => {
            const {
                default: defaultValue = '',
                field,
                list = []
            } = data || {};

            const defaultStr = defaultValue !== null && defaultValue !== undefined ? String(defaultValue) : '';

            return list.map(item => {
                // 标准化值处理
                const value = (item.value ?? item)?.toString() ?? '',
                    title = (item.title ?? item)?.toString() ?? '',
                    checked = value === defaultStr ? 'checked' : '';
                return `<input type="radio" name="${field}" value="${value.replace(/"/g, '&quot;')}" title="${title.replace(/"/g, '&quot;')}" lay-filter="${field}" ${checked}>`;
            }).join('');
        },
        MoneyInput = (data) => {
            let _title = data.title_edit && typeof data.title_edit !== 'undefined' ? data.title_edit : data.title,
                _value = typeof data.default !== 'undefined' ? data.default.toString() : ``,
                _required = data.required && typeof data.required !== 'undefined' ? `required='true' lay-verify='required'` : ``,
                _disabled = data.disabled && typeof data.disabled !== 'undefined' ? `disabled='true'` : ``,
                _verify = data.required_list && typeof data.required_list !== 'undefined' ? `lay-verify='required|${data.required_list}'` : ``,
                _unit = data.unit && typeof data.unit !== 'undefined' ? `<div class="ery-ipt-icon ery-bg-white-4" style='border-top-right-radius: 4px;border-bottom-right-radius: 4px;'>${data.unit}</div>` : ``,
                _inpstyle = _unit ? `style='border-top-right-radius: 0;border-bottom-right-radius: 0;'` : ``;

            let temp = `<input class="ery-ipt" placeholder="请输入${_title}" lay-precision="2" type="text" name="${data.field}" value="${_value}" id="${data.field}" ${_required} ${_verify}  ${_inpstyle} ${_disabled}>${_unit}`;
            if(_unit){
                temp = `<div class="layout ery-form-itemnowarp">${temp}</div>`
            }
            return temp;
        },
        CheckboxGroup = (data) => {
            const {
                default: defaultValue = [],
                required = false,
                disabled = false,
                required_list = '',
                list = [],
                field = ''
            } = data || {};
            // 转换默认值为字符串数组
            const defaultValues = Array.isArray(defaultValue) ? defaultValue.map(String) : [String(defaultValue)];
            // 准备通用属性
            const baseAttrs = [];
            if (required) baseAttrs.push(`lay-verify="required"`);
            if (disabled) baseAttrs.push('disabled');
            if (required_list) baseAttrs.push(`lay-verify="${required_list}"`);
            // 构建复选框组
            const res = list.map(item => {
                const { value, title = '' } = item || {};
                const checked = defaultValues.includes(String(value)) ? 'checked' : '';
                return `<div class="ery-mag-t5"><input type="checkbox" name="${field}[]" value="${String(value).replace(/"/g, '&quot;')}" title="${String(title).replace(/"/g, '&quot;')}" ${checked} ${baseAttrs.join(' ')} lay-filter="${field}" lay-skin="primary"></div>`;
            }).join('');
            return `<div class="layout ery-fex-l">${res}</div>`;
        },
        SelectField = (data) => {
            const {
                    default: defaultValue = '',
                    required = false,
                    required_list = '',
                    disabled = false,
                    title_edit = '',
                    title = '',
                    text = false,
                    list = [],
                    field = ''
                } = data || {},
                defaultStr = defaultValue !== null && defaultValue !== undefined ? String(defaultValue) : '',
                attributes = [];
            if (required) attributes.push('lay-verify="required"');
            if (required_list) attributes.push(`lay-verify="${required_list}"`);
            if (disabled) attributes.push('disabled');

            const selectTitle = title_edit ? `请选择${title_edit}` : `请选择${title}`,
                options = list.map(item => {
                    const value = item.value?.toString() ?? '',
                        titleText = item.title?.toString() ?? '',
                        selected = value === defaultStr ? 'selected' : '';

                    return `<option value="${value.replace(/"/g, '&quot;')}" ${selected}>${titleText.replace(/</g, '&lt;').replace(/>/g, '&gt;')}</option>`;
                });
            if (text) {
                options.unshift(`<option value="">${selectTitle.replace(/</g, '&lt;').replace(/>/g, '&gt;')}</option>`);
            }
            return `<select name="${field}" id="${field}" ${attributes.join(' ')} lay-filter="${field}">${options.join('')}</select>`;
        },
        IconPicker = (data) => {
            let _icon = data.default && typeof data.default !== 'undefined' ? data.default : `im-icon im-add`,
                _value = data.default && typeof data.default !== 'undefined' ? data.default : ``,
                _del = data.default && typeof data.default !== 'undefined' ? `` : `style='display: none'`;
            console.log(data.default)
            console.log(_value)
            return `<div class="ery-fex-l ery-fex-itemsc"> <div class="ery-fex-c ery-fex-itemsc ery-bor ery-bor-white-3" style="width: 50px;height: 50px;"> <i class="${data.field}icon _${data.field}-open ${_icon}" style="font-size: 2rem"></i> </div> <div class="ery-mag-l15"> <a class="ery-button-s ery-bor-green _${data.field}-open">选择图标</a> <a class="ery-button-s ery-bor-red ery-mag-l5 _${data.field}-del" ${_del}>删除图标</a> </div> </div><input type="hidden" class="ery-ipt ${data.field}val" name="${data.field}" value="${_value}"> 
<script>
layui.use(function () {
    const layer = layui.layer,
        ECms = new EruCms();
    let ${data.field}icon = [];
    const Get${data.field}icon = async () => {
            let res = await ECms.EGet('/hook/piece.html',{n:'icon'});
            if(res.code.toString() === '0'){
                layer.msg('获取图标失败');
                return false;
            }
            let tpl = '';
            $.each(res.data,function (i,v){
                tpl += \`<li class="ery-pad-a10"><i class='im-icon \${v} _${data.field}-add' style='font-size:3rem;' data-icon='\${v}'></i></li>\`;
            });
            $('body').append(\`<ul class='_${data.field}-box ery-fex-l' style='display: none;'>\${tpl}</ul>\`);
            Add${data.field}Fun();
        },
        Add${data.field}Fun = () => {
            $(\`._${data.field}-open\`).on('click',function () {
                layer.open({ type: 1, title: "选择图标", content: $('._${data.field}-box'), area:['70%','70%'], });
            });
            $(\`._${data.field}-add\`).on('click',function () {
                let icon = \$(this).data('icon');
                $(\`.${data.field}icon\`).attr('class',\`im-icon \${icon}\`).addClass(\`_${data.field}-add ${data.field}icon\`);
                $(\`.${data.field}val\`).val(\`im-icon \${icon}\`);
                $(\`._${data.field}-del\`).show();
                layer.closeAll('page');
            });
            $(\`._${data.field}-del\`).on('click',function () {
               $(\`.${data.field}icon\`).attr('class',\`im-icon im-add _${data.field}-add ${data.field}icon\`);
                $(\`.${data.field}val\`).val('');
                $(\`._${data.field}-del\`).hide();
            });
        };
    Get${data.field}icon();
});
</script>`;
        },
        RichTextEditor = (data) => {
            let _value = data.default && typeof data.default !== 'undefined' ? data.default : ``;
            return `<div id="editor-${data.field}"></div>
        <textarea name="${data.field}" class="_${data.field} ery-hidden">${_value}</textarea>
<script>
let E = window.wangEditor,
        ${data.field}editor = new E('#editor-${data.field}');
    ${data.field}editor.config.fontSizes = {
        'x-small': { name: '12px', value: '1' },
        'small': { name: '14px', value: '2' },
        'normal': { name: '16px', value: '3' },
        'large': { name: '18px', value: '4' },
        'x-large': { name: '24px', value: '5' },
        'xx-large': { name: '32px', value: '6' },
        'xxx-large': { name: '48px', value: '7' },
    };
    ${data.field}editor.config.colors = [
        '#000000',
        '#333333',
        '#666666',
        '#999999',
        
        '#cc0033',
        '#FF3300',
        '#FF0000',
        '#FF0066',
        
        '#000066',
        '#000099',
        '#0000CC',
        '#0000FF',
        
        '#006600',
        '#009900',
        '#00CC00',
        '#00FF00',
        
        '#FF6600',
        '#FF9900',
        '#FFCC00',
        '#FFFF00',
    ];
    ${data.field}editor.config.uploadImgServer = '/hook/upload/wangeditor.html';
    ${data.field}editor.config.showLinkImg = false;
    ${data.field}editor.config.uploadImgMaxLength = 50;
    
    ${data.field}editor.config.height = 480;
    ${data.field}editor.config.onchange = function (html) {
        $('._${data.field}').val(html)
    };
    ${data.field}editor.create();
    ${data.field}editor.txt.html(\`${_value}\`);
</script>`;
        },
        SingleFileUpload = (data,type) => {
            let _value = typeof data.default !== 'undefined' ? data.default.toString() : ``,
                _required = data.required && typeof data.required !== 'undefined' ? `required='true'` : ``,
                _img = _value ? `<img src="${_value}" class="ery-img-responsive">` : `<i class="im-icon im-upload ery-text-f20"></i>`,
                _del = _value ? `<i class="im-icon im-delete ery-text-red ery-pos-a" onclick="${data.field}del(this)" style="background-color: rgba(255,255,255,0.3);top: 0;right: 0;"></i>` : ``,
                _script = `<script>
    let ${data.field}upload = new EUpload({
        monitor:"._${data.field}box",
        url:'/hook/upload/save.html',
        autoup:true,
    });
    ${data.field}upload.process = function (obj){
        const url = URL.createObjectURL(obj.file);
        let t = \`<img src='\$\{url\}' class='ery-img-responsive' data-key="\$\{obj.md5\}">\`,
            _del = \`<i class="im-icon im-delete ery-text-red ery-pos-a del\$\{obj.md5\}" style="background-color: rgba(255,255,255,0.3);top: 0;right: 0;"></i>\`;
        if(this.config.exp && this.config.exp !== 'image'){
            t = \`<i class="im-icon im-file" style='font-size:3rem;'></i>\`;
        }
        \$(this.config.monitor).html(t).after(_del);
        return {paused: '', del: \`del\$\{obj.md5\}\`};
    }
    ${data.field}upload.Del = function (res,obj){
        ${data.field}del(\`.del\$\{obj.md5\}\`);
    }
    ${data.field}upload.success = function (res,obj){
        if(res.code.toString() === '1'){
            \$(\`._${data.field}val\`).val(res.data.url);
        }
    }
function ${data.field}del(o){
    \$(\`._${data.field}box\`).html(\`<i class="im-icon im-upload ery-text-f20"></i>\`);
    \$(\`._${data.field}val\`).val(\`\`);
    \$(o).remove();
}
</script>`;
            switch (type){
                case 'zip':
                    _img = `<i class="im-icon im-fuwuqi ery-text-f20"></i>`;
                    break;
                case 'file':
                    _img = `<i class="im-icon im-file ery-text-f20"></i>`;
                    break;
                case 'video':
                    _img = `<video src="${_value}"></video>`;
                    break;
            }
            return `<div class="ery-upload-box"><div class="ery-bg-imgbox ery-bor ery-bor-white-3">
    <div class="ery-bg-img ery-fex-c ery-fex-itemsc _${data.field}box" data-name="${data.field}" data-exp="${data.type}" data-filenum="1">${_img}</div>${_del}
</div><input class="layout _${data.field}val" type="hidden" name="${data.field}" value="${_value}" ${_required}></div>${_script}`;
        },
        MultiFileUpload = (data,type) => {
            let _type = type === 'images' ? 'image/*' : '',
                _list = typeof data.default !== 'undefined' ? data.default : ``,
                _img = type === 'images' ? `` : `<i class="im-icon im-upload"></i>`,
                _temp = ``;
            if(_list){
                $.each(_list,function (k,v){
                    _temp += `<div class="ery-upload-box ery-pad-a10 _${data.field}${k}">
    <div class="ery-bg-imgbox ery-bor ery-bor-white-3">
    <div class="ery-bg-img ery-fex-c ery-fex-itemsc">
    <img src="${v.url}" onerror="this.src='/public/static/image/imgnone.jpg'" class="ery-img-responsive">
    <input type="hidden" class="${data.field}${k}title" name="${data.field}[${k}][title]" value="${v.title}">
    <input type="hidden" class="${data.field}${k}url" name="${data.field}[${k}][url]" value="${v.url}">
    <input type="hidden" class="${data.field}${k}size" name="${data.field}[${k}][size]" value="${v.size}">
    </div>
    <div class="ery-upload-delicon" onclick="del${data.field}(this)"><i class="im-icon im-delete"></i></div>
    </div>
    </div>`;
                });
            }
            return `<div class="layout ery-fex-l _${data.field}list"><div class="ery-upload-box ery-pad-a10">
<div class="ery-bg-imgbox ery-bor ery-bor-white-3">
    <div class="ery-bg-img ery-fex-c ery-fex-itemsc _${data.field}box" data-name="${data.field}">
    <i class="im-icon im-upload"></i>
    </div>
</div>
</div>
${_temp}
</div><script>
let ${data.field}upload = new EUpload({
        monitor:"._${data.field}box",
        url:'/hook/upload/save.html',
        autoup:true,
        filetype: '${_type}',
        multiple:true,
});
 ${data.field}upload.process = function (obj){
     const url = URL.createObjectURL(obj.file);
     let t = \`<div class="ery-upload-box ery-pad-a10 _\${obj.md5}">
<div class="ery-bg-imgbox ery-bor ery-bor-white-3">
<div class="ery-bg-img ery-fex-c ery-fex-itemsc">
<img src="\${url}" onerror="this.src='/public/static/image/file.png'" class="ery-img-responsive">
<input type="hidden" class="\${obj.md5}title" name="\${this.config.name}[\${obj.md5}][title]" value="">
<input type="hidden" class="\${obj.md5}url" name="\${this.config.name}[\${obj.md5}][url]" value="">
<input type="hidden" class="\${obj.md5}size" name="\${this.config.name}[\${obj.md5}][size]" value="">
</div>
<div class="ery-upload-delicon del\$\{obj.md5\}"><i class="im-icon im-delete"></i></div>
</div>
</div>\`;
        \$(\`._\${this.config.name}list\`).append(t);
     return {paused: '', del: \`del\$\{obj.md5\}\`};
 }
${data.field}upload.success = function (res,obj){
    if(res.code.toString() === '1'){
        \$(\`.\${obj.md5}title\`).val(res.data.title);
        \$(\`.\${obj.md5}url\`).val(res.data.url);
        \$(\`.\${obj.md5}size\`).val(res.data.size);
    }
}
function del${data.field}(o){
    \$(o).closest('.ery-upload-box').remove();
}
</script>`;
        },
        ModelSelector = (data) => {
            let _required = data.required && typeof data.required !== 'undefined' ? `required='true' lay-verify='required'` : ``,
                _temp = `<div class='layout ery-mag-b10'><input class="_${data.field}so ery-ipt" placeholder="搜索${data.title}" value=""></div><div class='_${data.field}list'></div><div class='_${data.field}page'></div><input name="${data.field}" type="hidden" class="_${data.field}val" value="${data.default}" ${_required}>`;
            if(data.gettype.toString() === '0'){
                _temp = `<div class='layout ery-mag-b10'><input class="_${data.field}so ery-ipt" placeholder="搜索${data.title}" value=""></div><div class='_${data.field}list'></div><div class='_${data.field}page'></div>`;
            } else if(data.gettype.toString() === '2'){
                _temp = `<select name="${data.field}" class='_${data.field}list' id="${data.field}" ${_required} lay-filter="${data.field}" lay-search></select>`;
            }
            return `${_temp}
<script>
            layui.use(function (){
                let layform = layui.form,
                    _${data.field}pages = false,
                    _${data.field}getweb = {total:0,per_page:0,current_page:0,last_page:0},
                    _${data.field}temp = (_data) => {
                        _data = JSON.parse(_data);
                        if('${data.gettype}' === '0'){
                            let checked = _data.${data.fielddata.value}.toString() === '${data.default}' ? 'checked' : '';
                            return \`<input type='radio' name="${data.field}" value='\${_data.${data.fielddata.value}}' title='\${_data.${data.fielddata.title}}' lay-filter="${data.field}" \${checked}>\`;
                        }else if('${data.gettype}' === '1') {
                            let _default = '${data.default}';
                                _default = _default.split(',');
                            let checked = $.inArray(_data.${data.fielddata.value}.toString(),_default) > -1 ? 'checked' : '';
                                return \`<input type='checkbox' name="_${data.field}[]" value='\${_data.${data.fielddata.value}}' title='\${_data.${data.fielddata.title}}' lay-skin="primary" lay-filter="${data.field}" \${checked}>\`;
                        }else{
                             let _selected = _data.${data.fielddata.value}.toString() === '${data.default}' ? 'selected' : '';
                             return \`<option value="\${_data.${data.fielddata.value}}" \${_selected}>\${_data.${data.fielddata.title}}</option>\`;
                        }
                    },
                     _${data.field}click = () => {
                        let _getweb = _${data.field}getweb;
                        $('.${data.field}gopage').click(function (o){
                            let _d = $(o.target).data();
                            _getweb.current_page = _d.page;
                            _get${data.field}list();
                        });
                     },
                    _get${data.field}list = async (_data = {},success = '') => {
                        if(_${data.field}pages){
                            _data.page = _${data.field}getweb.current_page;
                            _data.limit = _${data.field}getweb.per_page;
                        }
                        const ECms = new EruCms();
                        let res = await ECms.EGet('${data.geturl}',_data);
                        if(res.data.total){
                            _${data.field}pages = true;
                            _${data.field}getweb = {total:res.data.total,per_page:res.data.per_page,current_page:res.data.current_page,last_page:res.data.last_page};
                            let _p = _${data.field}getweb.current_page * 1 - 1,
                                _n = _${data.field}getweb.current_page * 1 + 1,
                                _pbtn = _p > 0 ? '${data.field}gopage' : 'layui-disabled',
                                _nbtn = _n > _${data.field}getweb.last_page ? 'layui-disabled' : '${data.field}gopage';
                            $('._${data.field}page').html(\`<div class="layui-box layui-laypage layui-laypage-default"><a class="layui-laypage-prev \${_pbtn}" data-page="\${_p}">上一页</a><a class="layui-laypage-next \${_nbtn}" data-page="\${_n}">下一页</a></div>\`);
                            _${data.field}click();
                        }
                        if(typeof success == 'function'){
                            return success(res);
                        }
                        let _list = res.data.total ? res.data.data : res.data,
                            _temp = \`\`;
                        if ('${data.gettype}'.toString() === '2'){
                           _temp += '<option value="" >请选择${data.title}</option>';
                        }
                        $.each(_list,function (k,v){
                            _temp += _${data.field}temp(JSON.stringify(v));
                        });
                        if(_${data.field}pages){
                            _temp = \`<div class='ery-fex-l ery-fex-column'>\${_temp}</div>\`;
                        } 
                        $('._${data.field}list').html(_temp);
                        if ('${data.gettype}'.toString() === '0'){
                            layform.render('radio');
                        }else if ('${data.gettype}'.toString() === '1'){
                            layform.render('checkbox');
                        }else if ('${data.gettype}'.toString() === '2'){
                            layform.render('select');
                        }
                    };
                layform.on('checkbox(${data.field})', function(data){
                    let _data = $(\`._${data.field}val\`).val();
                    _data = _data.split(',');
                    if(data.elem.checked){
                        _data.push(data.value);
                    } else {
                        $.each(_data,function(index,item) {
                            if(item.toString() === data.value.toString()){
                                _data.splice(index,1);
                            }
                        });
                    }
                    $('._${data.field}val').val(_data.toString());
                });
                $('._${data.field}so').bind("input propertychange",function(){
                        _${data.field}getweb.current_page = 1;
                        _get${data.field}list({key:\$(this).val()});
                });
                _get${data.field}list();
})
</script>`;
        },
        ChinaFucode = (data) => {
          return '';
        },
        FileLink = (linkdata, type, _file, _val = null) => {
            const safeVal = JSON.stringify(_val),
                safeFile = _file.replace(/[^a-zA-Z0-9_]/g, ''),
                linkMap = new Map(
                    Object.entries(linkdata).map(([key, value]) =>
                        [key, Array.isArray(value) ? value : [value]]
                    )
                );
            return `<script>
                    layui.use(function() {
                        const layform = layui.form,
                            linkMap = new Map(${JSON.stringify(Array.from(linkMap))}),
                            initValue = ${safeVal};
                        
                        ${safeFile}${type} = (value) => {
                            const allClasses = [...new Set([...linkMap.values()].flat())];
                            allClasses.forEach(cls => {
                                $(\`._\${cls}\`).addClass('ery-hidden');
                            });
                            if (linkMap.has(value.toString())) {
                                linkMap.get(value.toString()).forEach(cls => {
                                    $(\`._\${cls}\`).removeClass('ery-hidden');
                                });
                            }
                        }
                        ${safeFile}${type}(initValue);
                        layform.on('${type}(${_file})', function(data) {
                            ${safeFile}${type}(data.value);
                        });
                    });
                    </script>`;
        },
        FormType = (data) => {
            const handlers = {
                    text: () => InputField(data),
                    textarea: () => InputField(data),
                    number: () => InputField(data),
                    hidden: () => InputField(data),
                    date: () => DatePicker(data),
                    datetime: () => DatePicker(data, true),
                    radio: () => RadioGroup(data),
                    money: () => MoneyInput(data),
                    checkbox: () => CheckboxGroup(data),
                    select: () => SelectField(data),
                    icon: () => IconPicker(data),
                    editor: () => RichTextEditor(data),
                    file: () => SingleFileUpload(data, 'file'),
                    image: () => SingleFileUpload(data, 'image'),
                    video: () => SingleFileUpload(data, 'video'),
                    zip: () => SingleFileUpload(data, 'zip'),
                    files: () => MultiFileUpload(data, 'files'),
                    images: () => MultiFileUpload(data, 'images'),
                    zips: () => MultiFileUpload(data, 'zips'),
                    getmodel: () => ModelSelector(data),
                    chinafucode: () => ChinaFucode(data)
                };
            let _temp = handlers[data.type]();
            const isHidden = data.type === 'hidden',
                title = data.title_edit || data.title,
                boxClass = data.boxwidth || 'layout',
                required = data.required ? `<span class="ery-text-red">*</span>` : '',
                hintText = data.tip ? `<div class="layout ery-text-black-3 ery-text-f14 ery-pad-lr10 ery-text-lh">${data.tip}</div>` : '';
            let scp = '';
            if(data.file_link){
                scp = FileLink(data.file_link,data.type,data.field,data.default);
            }
            // 返回完整的表单HTML结构
            return `<div class="${boxClass} ery-form-group ery-mag-b20 _${data.field}" ${isHidden ? "style='display:none;'" : ""}>
                    <label class="ery-label _${data.field}-label" for="${data.field}">${required}${title}</label>
                    <div class="ery-form-item _${data.field}-cont">${_temp}${hintText}${scp}</div>
                </div>`;
        };
    // 处理层级数据
    const EachFormList = (list, pid = '0', level = 0) => {
            const currentLevelItems = list.filter(item => item.pid.toString() === pid.toString());
            if (currentLevelItems.length === 0) return [];
            return currentLevelItems.map(item => {
                const children = EachFormList(list, item.id, level + 1);
                const newNode = {
                    ...item,
                    level: level,
                    isLeaf: children.length === 0
                };
                if (children.length > 0) {
                    newNode.node = children;
                }
                return newNode;
            });
        };
    // 注册表格事件
    const EventTable = {
            init: (tabid) => {
                laytable.on('tool('+tabid+')', function (obj) {
                    let _event = obj.event,
                        _this = this,
                        elementData = $($(_this).find(`._${_event}`)).data();
                    try {
                        // 创建事件上下文
                        const context = {
                            obj,
                            data: obj.data,
                            _event,
                            elementData,
                            tabid
                        };
                        // 交给事件管理器处理
                        EventTable.handle(context);
                    } catch (error) {
                        layer.msg('操作处理失败，请重试', { icon: 2, time: 2000 });
                    }
                });
                laytable.on(`toolbar(${tabid})`, function(obj){
                    let checkStatus = laytable.checkStatus(obj.config.id).data,
                        elementData = $(this).data();
                    if($.inArray(obj.event,['LAYTABLE_COLS','LAYTABLE_EXPORT','LAYTABLE_PRINT']) !== -1){
                        return false;
                    }
                    if((typeof elementData.check === 'undefined' || elementData.check) && checkStatus.length === 0){
                        layer.msg('您还没有选择内容！');
                        return false;
                    }
                    try {
                        // 创建事件上下文
                        const context = {
                            obj,
                            data: checkStatus,
                            elementData,
                            tabid
                        };
                        // 交给事件管理器处理
                        EventTable.handle(context);
                    } catch (error) {
                        layer.msg('操作处理失败，请重试', { icon: 2, time: 2000 });
                    }
                });
            },
            async handle(context) {
                const { event } = context.obj,
                    handlers = this[event] || [];
                if (handlers.length === 0) {
                    // 没有注册自定义事件处理器时使用默认处理器
                    return this.Default(context);
                }
                await this[event](context);
            },
            async del(context) {
                const { data,elementData,tabid } = context;
                layer.confirm(elementData.tip ? elementData.tip : '删除后不可恢复，是否确认删除？', {icon: 3, title:'警告'}, async function(index){
                    layer.close(index);
                    layer.load(1);
                    let res = await ECms.EPost(elementData.url,{data:data,_method:'delete'},{headers:{'Content-Type':'application/json'}});
                    layer.closeAll('loading');
                    layer.msg(res.msg);
                    if(res.code.toString() === '1') {
                        laytable.reloadData(tabid);
                    }
                });
            },
            async Default(context) {
                const { data,elementData,tabid } = context;
                if(elementData.tip){
                    layer.confirm(elementData.tip, {icon: 3, title:'温馨提示'}, async function (index){
                        layer.load(1);
                        let res = await ECms.EPost(elementData.url,data,{headers:{'Content-Type':'application/json'}});
                        layer.closeAll('loading');
                        layer.msg(res.msg);
                        if(res.code.toString() === '1') {
                            laytable.reloadData(tabid);
                        }
                    })
                    return false;
                }
                layer.load(1);
                let res = await ECms.EPost(elementData.url,data,{headers:{'Content-Type':'application/json'}});
                layer.closeAll('loading');
                layer.msg(res.msg);
                if(res.code.toString() === '1') {
                    laytable.reloadData(tabid);
                }
            }
        },
        EditTd = async (web_base,tabid) => {
            laytable.on(`edit(${tabid})`, async function(obj){
                layer.load(1);
                let res = await ECms.EPost(web_base.fast_url,{data:obj.data,filed:obj.field,value:obj.value,_method:'PUT'},{headers:{'Content-Type':'application/json'}});
                layer.closeAll('loading');
                layer.msg(res.msg);
            });
        };
    const eru = {};
    // 初始化表格
    eru.InitTable = (data,flod = '0') => {
        return data.map(item => {
            const config = {
                field: item.field || '',
                title: item.title || '',
                fieldTitle: item.title_edit || '',
                align: item.textalign || 'left',
                sort: item.sort || false,
            };
            if (item.width) {
                config.width = item.width.includes('%') ? item.width : parseInt(item.width, 10);
            }
            if(item.min_width){
                config.minWidth = item.min_width;
            }
            if(item.max_width){
                config.maxWidth = item.max_width;
            }
            if(item.fixed){
                config.fixed = item.fixed;
            }
            const processedConfig = TableType(config, item);
            if(flod !== '0' && v.file === 'title'){
                processedConfig.templet = function(d){
                    return d.title_display
                }
            }
            return processedConfig;
        });
    }
    // 渲染表格
    eru.RenderTable = async (conf, data, webconf) => {
        let config = {
                elem: `#${conf.id}`,
                height: `full-40`,
                url: webconf.url,
                page: webconf.page,
                limit: webconf.page ? '20' : '0',
                defaultToolbar: [],
                response: {
                    statusCode: '1'
                },
                cols: [data],
            };
        config = {
            ...config,
            ...conf
        };
        if(webconf.fold && webconf.fold > '0'){
            config.tree = {
                customName: {
                    name: 'title',
                    pid: 'pid',
                    children: 'node',
                },
                data: {
                    rootPid: '0',
                },
                view: {
                    indent: '20',
                }
            };
            config.parseData = function (res) {
                res.data = EachFormList(res.data);
                return res;
            }
            treeTable.render(config);
        } else {
            laytable.render(config);
        }
        EventTable.init(conf.id);
        EditTd(webconf,conf.id);
        let _datelist = $(`._date`);
        if(_datelist.length > '0'){
            $.each(_datelist,function (k,v){
                laydate.render({
                    elem: this,
                });
            });
        }
        layform.on('submit(formsobtn)', function(data){
            laytable.reloadData(conf.id,{
                where: data.field,
                page: {
                    curr: 1
                }
            });
            return false;
        });
    }
    // 处理表单
    eru.InitForm = (data) => {
        data = data.map(item => {
            return {
                template: FormType(item),
                field: item.field,
                group: item.group || 'stop'
            }
        });
        return data;
    }
    eru.ViewForm = function(classname,trlist,fun = ''){
        $.each(trlist,function (k,v){
            if(v.group.toString() !== 'stop'){
                $(`.${classname}${v.group}`).before(v.template);
            } else {
                $(`.${classname}`).before(v.template);
            }
        });
        layform.render();
        if(typeof fun === 'function'){
            fun();
        }
    }

    exports('eruyun_table', eru);
});