<?php
/**
 * This file is part of webman.
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the MIT-LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @author    walkor<walkor@workerman.net>
 * @copyright walkor<walkor@workerman.net>
 * @link      http://www.workerman.net/
 * @license   http://www.opensource.org/licenses/mit-license.php MIT License
 */

namespace support\view;

use think\Template;
use Webman\View;
use function app_path;
use function array_merge;
use function base_path;
use function config;
use function is_array;
use function ob_get_clean;
use function ob_start;
use function request;
use function runtime_path;

/**
 * Class Blade
 * @package support\view
 */
class ThinkPHP implements View
{
    /**
     * Assign.
     * @param string|array $name
     * @param mixed $value
     */
    public static function assign(string|array $name, mixed $value = null): void
    {
        $request = request();
        $request->_view_vars = array_merge((array) $request->_view_vars, is_array($name) ? $name : [$name => $value]);
    }

    /**
     * Render.
     * @param string $template
     * @param array $vars
     * @param string|null $app
     * @param string|null $plugin
     * @return string
     */
    public static function render(string $template, array $vars, ?string $app = null, ?string $plugin = null): string
    {
        $request = request();
        //  获取模板配置
        $view_conf = $request->viewconf ?? config('view.options');
        $view_app = $view_conf['app'] ?? '';
        if(!is_dir(public_path("/{$view_app}/{$view_conf['default_dir']}/template/"))){
            $view_conf = config('view.options');
        }
        //  定义模板后缀
        $viewSuffix = $view_conf['view_suffix'] ?? 'htm';
        //  定义模板目录
        $viewPath = public_path("/{$view_app}/{$view_conf['default_dir']}/template/");

        $defaultOptions = [
            'view_path' => $viewPath,
            'cache_path' => runtime_path("views/{$view_app}/"),
            'view_suffix' => $viewSuffix
        ];
        $options = $defaultOptions + $view_conf;

        $views = new Template($options);
        ob_start();
        if(isset($request->_view_vars)) {
            $vars = array_merge((array)$request->_view_vars, $vars);
        }
        $views->fetch($template, $vars);
        return ob_get_clean();
    }
}
